<?php

namespace idoit\Module\Cmdb\Component\CategoryChanges\Type;

use idoit\Component\Property\Property;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\ChangesData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\DataProvider;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\DefaultData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\RequestData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\SmartyData;
use isys_application;
use isys_cmdb_dao_category;
use isys_cmdb_dao_dialog;
use isys_tenantsettings;

/**
 * Class DialogType
 *
 * Handling dialog types
 *
 * @package idoit\Module\Cmdb\Component\CategoryChanges\Type
 */
class DialogType extends AbstractType implements TypeInterface
{
    /**
     * @param Property $property
     * @param string   $tag
     *
     * @return bool
     */
    public function isApplicable(Property $property, string $tag)
    {
        $references = $property->getData()->getReferences();
        return $property->getInfo()->getType() === Property::C__PROPERTY__INFO__TYPE__DIALOG && is_array($references) && !empty($references);
    }

    /**
     * @param string                 $tag
     * @param isys_cmdb_dao_category $dao
     * @param RequestData            $requestDataProvider
     * @param SmartyData             $smartyDataProvider
     * @param array                  $currentData
     *
     * @return array
     */
    public function handlePostData(string $tag, isys_cmdb_dao_category $dao, RequestData $requestDataProvider, SmartyData $smartyDataProvider, array $currentData = [])
    {
        $requestData = $requestDataProvider->getData();
        $smartyData = $smartyDataProvider->getData();
        $property = $this->getProperty();
        $dataReference = $property->getData()->getReferences();
        $uiField = $property->getUi()->getId();
        $currentObjectId = $dao->get_object_id();
        $currentPropertyTag = $this->getCurrentPropertyTag($dao, $tag);
        $changes = [];
        $newValueId = (int)$requestData[$uiField];
        $oldValueId = (int)$smartyData[$uiField]['p_strSelectedID'];
        $oldValue = [];
        $emptyState = isys_tenantsettings::get('gui.empty_value', '-');
        $dialogInstance = isys_cmdb_dao_dialog::instance(isys_application::instance()->container->get('database'));
        $dialogInstance
            ->set_table($dataReference[0])
            ->load();

        if ($newValueId === $oldValueId || ($newValueId <= 0 && $oldValueId <= 0)) {
            return [];
        }

        if ($oldValueId > 0) {
            $oldValue = $dialogInstance->get_data($oldValueId);
        }

        if ($newValueId > 0) {
            $newValue = $dialogInstance->get_data($newValueId);
        }

        $changes = ChangesData::factory(
            [
                $currentPropertyTag => [
                    self::CHANGES_FROM => !empty($oldValue) ? $oldValue['title'] : $emptyState,
                    self::CHANGES_TO =>  !empty($newValue) ? $newValue['title'] : $emptyState
                ]
            ],
            $currentObjectId
        );

        return [
            self::CHANGES_CURRENT => $changes,
            self::CHANGES_TO => $changes,
        ];
    }

    /**
     * @param DefaultData $currentData
     * @param DefaultData $changedData
     *
     * @return array
     */
    public function handleData(DefaultData $currentData, DefaultData $changedData)
    {
        // TODO: Implement handleData() method.
    }
}
