<?php

namespace idoit\Module\Cmdb\Component\CategoryChanges\Type;

use idoit\Component\Property\Property;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\ChangesData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\DefaultData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\RequestData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\SmartyData;
use isys_application;
use isys_cmdb_dao_category;
use isys_cmdb_dao_dialog;

/**
 * Class MultiselectType
 *
 * Handling multiselect types
 *
 * @package idoit\Module\Cmdb\Component\CategoryChanges\Type
 */
class MultiselectType extends AbstractType implements TypeInterface
{
    /**
     * @param Property $property
     * @param string   $tag
     *
     * @return bool
     */
    public function isApplicable(Property $property, string $tag)
    {
        return $property->getInfo()->getType() === Property::C__PROPERTY__INFO__TYPE__MULTISELECT;
    }

    /**
     * @param string                 $tag
     * @param isys_cmdb_dao_category $dao
     * @param RequestData            $requestDataProvider
     * @param SmartyData             $smartyDataProvider
     * @param array                  $currentData
     *
     * @return array
     */
    public function handlePostData(string $tag, isys_cmdb_dao_category $dao, RequestData $requestDataProvider, SmartyData $smartyDataProvider, array $currentData = [])
    {
        $requestData = $requestDataProvider->getData();
        $smartyData = $smartyDataProvider->getData();
        $property = $this->getProperty();
        $sourceTable = $property->getData()->getSourceTable();
        $references = $property->getData()->getReferences();
        $uiField = $property->getUi()->getId();
        $currentObjectId = $dao->get_object_id();
        $currentPropertyTag = $this->getCurrentPropertyTag($dao, $tag);
        $changes = [];
        $emptyState = '';
        $newValue = $requestData[$uiField] ?? [];
        $oldValue = (strlen($smartyData[$uiField]['p_strSelectedID']) > 0 ?
            explode(',', $smartyData[$uiField]['p_strSelectedID']) : []);
        natsort($newValue);
        natsort($oldValue);

        if (empty(array_diff($newValue, $oldValue)) && empty(array_diff($oldValue, $newValue))) {
            return [];
        }

        if (!empty($references)) {
            $sourceTable = $references[0];
        }

        $dialogInstance = isys_cmdb_dao_dialog::instance(isys_application::instance()->container->get('database'));
        $dialogInstance
            ->set_table($sourceTable)
            ->load();

        if (!empty($newValue)) {
            array_walk($newValue, function (&$item) use ($dialogInstance) {
                $data = $dialogInstance->get_data((int)$item);
                $item = $data['title'] ?? '';
            });
        }

        if (!empty($oldValue)) {
            array_walk($oldValue, function (&$item) use ($dialogInstance) {
                $data = $dialogInstance->get_data((int)$item);
                $item = $data['title'] ?? '';
            });
        }

        $changes = ChangesData::factory(
            [
                $currentPropertyTag => [
                    self::CHANGES_FROM => !empty($oldValue) ? implode(', ', $oldValue) : $emptyState,
                    self::CHANGES_TO =>  !empty($newValue) ? implode(', ', $newValue) : $emptyState
                ]
            ],
            $currentObjectId
        );

        return [
            self::CHANGES_CURRENT => $changes,
            self::CHANGES_TO => $changes,
        ];
    }

    /**
     * @param DefaultData $currentData
     * @param DefaultData $changedData
     *
     * @return array
     */
    public function handleData(DefaultData $currentData, DefaultData $changedData)
    {
        // TODO: Implement handleData() method.
    }
}
