<?php

/**
 * i-doit
 *
 * DAO: specific category list for contract assignment.
 *
 * @package     i-doit
 * @subpackage  CMDB_Category_lists
 * @author      Van Quyen Hoang <qhoang@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_list_catg_contract_assignment extends isys_component_dao_category_table_list
{

    /**
     * Gets category identifier.
     *
     * @return  integer
     */
    public function get_category()
    {
        return $this->m_cat_dao->get_category_id();
    }

    /**
     * Gets category type.
     *
     * @return  integer
     */
    public function get_category_type()
    {
        return $this->m_cat_dao->get_category_type();
    }

    /**
     * @param array $row
     *
     * @throws Exception
     */
    public function modify_row(&$row)
    {
        $l_table = $this->m_cat_dao->get_table();
        $locales = isys_application::instance()->container->get('locales');

        $row["object_title"] = isys_ajax_handler_quick_info::instance()->getQuickInfoReplacement(
            $row["isys_connection__isys_obj__id"],
            isys_application::instance()->container->get('cmdb_dao')->get_obj_name_by_id_as_string($row["isys_connection__isys_obj__id"])
        );

        if (empty($row[$l_table . '__contract_start']) || empty($row[$l_table . '__contract_end'])) {
            $contractData = isys_cmdb_dao_category_s_contract::instance($this->get_database_component())
                ->get_data(null, $row["isys_connection__isys_obj__id"])
                ->get_row();

            if (empty($row[$l_table . '__contract_start'])) {
                $row[$l_table . '__contract_start'] = $locales->fmt_date($contractData['isys_cats_contract_list__start_date']);
            } else {
                $row[$l_table . '__contract_start'] = $locales->fmt_date(str_replace("00:00:00", "", $row[$l_table . '__contract_start']));
            }

            if (empty($row[$l_table . '__contract_end'])) {
                $row[$l_table . '__contract_end'] = $locales->fmt_date($contractData['isys_cats_contract_list__end_date']);
            } else {
                $row[$l_table . "__contract_end"] = $locales->fmt_date(str_replace("00:00:00", "", $row[$l_table . '__contract_end']));
            }
        } else {
            $row[$l_table . '__contract_start'] = $locales->fmt_date(str_replace("00:00:00", "", $row[$l_table . '__contract_start']));
            $row[$l_table . "__contract_end"] = $locales->fmt_date(str_replace("00:00:00", "", $row[$l_table . '__contract_end']));
        }
    }

    /**
     * Gets fields to display in the list view.
     *
     * @return  array
     */
    public function get_fields()
    {
        $l_table = $this->m_cat_dao->get_table();
        $l_properties = $this->m_cat_dao->get_properties();

        return [
            'object_title'                => $l_properties['connected_contract'][C__PROPERTY__INFO][C__PROPERTY__INFO__TITLE],
            $l_table . '__contract_start' => $l_properties['contract_start'][C__PROPERTY__INFO][C__PROPERTY__INFO__TITLE],
            $l_table . '__contract_end'   => $l_properties['contract_end'][C__PROPERTY__INFO][C__PROPERTY__INFO__TITLE],
            $l_table . '__description'   => $l_properties['description'][C__PROPERTY__INFO][C__PROPERTY__INFO__TITLE],
        ];
    }
}
