<?php

/**
 * i-doit
 *
 * CMDB Global list DAO for stacking.
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @since       1.7
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_list_catg_stack_member extends isys_component_dao_category_table_list
{
    /**
     * Return constant of category.
     *
     * @return  integer
     * @author  Van Quyen Hoang <qhoang@i-doit.org>
     */
    public function get_category()
    {
        return defined_or_default('C__CATG__STACK_MEMBER');
    }

    /**
     * Return constant of category type.
     *
     * @return  integer
     * @author  Van Quyen Hoang <qhoang@i-doit.org>
     */
    public function get_category_type()
    {
        return C__CMDB__CATEGORY__TYPE_GLOBAL;
    }

    /**
     * Modifies row.
     *
     * @param  array &$p_row
     */
    public function modify_row(&$p_row)
    {
        global $g_dirs;

        $language = isys_application::instance()->container->get('language');

        $stackMemberObject = isys_application::instance()->container->get('cmdb_dao')
            ->get_object($p_row['isys_catg_stack_member_list__stack_member'])
            ->get_row();

        $p_row['obj_title'] = isys_ajax_handler_quick_info::instance()->getQuickInfoReplacement(
            $stackMemberObject['isys_obj__id'],
            $language->get($stackMemberObject['isys_obj_type__title']) . ' &raquo; ' . $stackMemberObject['isys_obj__title']
        );

        switch ($p_row['isys_catg_stack_member_list__mode']) {
            default:
            case null:
            case -1:
                $p_row['isys_catg_stack_member_list__mode'] = isys_tenantsettings::get('gui.empty_value', '-');
                break;

            case 1:
                $p_row['isys_catg_stack_member_list__mode'] = '<img src="' . $g_dirs['images'] . 'icons/silk/bullet_green.png" class="mr5 vam" />' .
                    $language->get('LC__UNIVERSAL__ACTIVE');
                break;

            case 0:
                $p_row['isys_catg_stack_member_list__mode'] = '<img src="' . $g_dirs['images'] . 'icons/silk/bullet_red.png" class="mr5 vam" />' .
                    $language->get('LC__UNIVERSAL__PASSIVE');
                break;
        }
    }

    /**
     * Method for returning the fields to display.
     *
     * @return  array
     * @author  Van Quyen Hoang <qhoang@i-doit.org>
     */
    public function get_fields()
    {
        return [
            "obj_title"                         => "LC__CATG__STACK_MEMBER__STACK_MEMBER",
            "isys_catg_stack_member_list__mode" => "LC__CATG__STACK_MEMBER__MODE"
        ];
    }

    /**
     * @param array $getParams
     *
     * @return string
     */
    public function make_row_link($getParams = [])
    {
        $objectField = '[{' . $this->get_dao_category()->get_connected_object_id_field() . '}]';

        return isys_helper_link::create_url([
            C__CMDB__GET__OBJECT   => $objectField,
            C__CMDB__GET__VIEWMODE => C__CMDB__VIEW__LIST_CATEGORY,
            C__CMDB__GET__CATG     => defined_or_default('C__CATG__GLOBAL'),
            C__CMDB__GET__TREEMODE => $getParams[C__CMDB__GET__TREEMODE]
        ]);
    }
}
