<?php

namespace idoit\Module\Cmdb\Component\CategoryChanges\Type\Browser;

use idoit\Component\Property\Property;
use idoit\Exception\Exception;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\ChangesData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\DefaultData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\RequestData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\SinglePropertyData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\SmartyData;
use idoit\Module\Cmdb\Component\CategoryChanges\Type\TypeInterface;
use idoit\Module\Cmdb\Interfaces\ObjectBrowserAssignedEntries;
use idoit\Module\Cmdb\Interfaces\ObjectBrowserReceiver;
use idoit\Module\Cmdb\Model\Entry\CollectionDataExtractor;
use idoit\Module\Cmdb\Model\Entry\Entry;
use isys_application;
use isys_cmdb_dao_category;
use isys_format_json;
use isys_popup_browser_object_ng;
use isys_tenantsettings;

class MultiSecondSelectObjectBrowserType extends MultiObjectBrowserType implements TypeInterface, ObjectBrowserTypeInterface
{
    /**
     * @param Property $property
     * @param string   $tag
     *
     * @return bool
     */
    public function isApplicable(Property $property, string $tag)
    {
        $params = $property->getUi()->getParams();
        return $property->getInfo()->getType() === Property::C__PROPERTY__INFO__TYPE__OBJECT_BROWSER &&
            $params[isys_popup_browser_object_ng::C__MULTISELECTION] &&
            $params[isys_popup_browser_object_ng::C__SECOND_SELECTION] &&
            $params['p_strPopupType'] === 'browser_object_ng';
    }

    /**
     * @param string                 $tag
     * @param isys_cmdb_dao_category $dao
     * @param RequestData            $requestDataProvider
     * @param SmartyData             $smartyDataProvider
     * @param array                  $currentData
     * @param array                  $propertiesAlwaysInLogbook
     *
     * @return array|null
     */
    public function handlePostData(
        string $tag,
        isys_cmdb_dao_category $dao,
        RequestData $requestDataProvider,
        SmartyData $smartyDataProvider,
        array $currentData = [],
        array $propertiesAlwaysInLogbook = []
    ) {
        $requestData = $requestDataProvider->getData();
        $smartyData = $smartyDataProvider->getData();
        $property = $this->getProperty();
        $uiField = $property->getUi()
            ->getId();
        $alwaysInLogbook = $property->getInfo()->isAlwaysInLogbook();
        $uiHiddenField = $uiField . '__HIDDEN';
        $uiConfigField = $uiField . '__CONFIG';
        $currentObjectId = $dao->get_object_id();
        $currentPropertyTag = $this->getCurrentPropertyTag($dao, $tag);
        $changes = [];

        if (!$requestDataProvider->hasKey($uiField)
            && $requestDataProvider->hasKey(C__POST__POPUP_RECEIVER)
            && $dao instanceof ObjectBrowserAssignedEntries
        ) {
            return $this->handlePopupReceiver($tag, $dao, $requestDataProvider, $smartyDataProvider, $currentData);
        }

        $oldValueConfig = is_string($requestData[$uiConfigField]) ? isys_format_json::decode($requestData[$uiConfigField]) : [];
        $oldValueId = str_replace('"', '', (string)$oldValueConfig['p_strSelectedID']);
        $oldValue = $oldValueConfig['p_strValue'] ? explode(', ', trim((string)$oldValueConfig['p_strValue'])) : [];
        $newValueId = (string)$requestData[$uiHiddenField];
        $newValue = isys_tenantsettings::get('gui.empty_value', '-');
        $formatSelectionListFormat = $oldValueConfig[isys_popup_browser_object_ng::C__SECOND_LIST_FORMAT];
        [$selectionClass, $selectionMethod] = explode('::', $formatSelectionListFormat);

        if (isys_format_json::is_json_array($newValueId)) {
            $newValueId = isys_format_json::decode($newValueId);
            asort($newValueId);
        }

        if (isys_format_json::is_json_array($oldValueId)) {
            $oldValueId = isys_format_json::decode($oldValueId);
            asort($oldValueId);
        }

        $valueCheck = empty(array_diff($oldValueId, $newValueId)) && empty(array_diff($newValueId, $oldValueId));
        $selectionClassCheck = class_exists($selectionClass);

        if (!$selectionClassCheck || ($valueCheck && !$alwaysInLogbook)) {
            return [];
        }

        $selectionClassInstance = $selectionClass::instance(isys_application::instance()->container->get('database'));
        if (!method_exists($selectionClassInstance, $selectionMethod)) {
            return [];
        }

        if (is_array($newValueId) && !empty($newValueId)) {
            $newValueIds = isys_format_json::decode($newValueId);
            $newValueArr = [];
            foreach ($newValueIds as $id) {
                $newValueArr[] = (string)$selectionClassInstance->$selectionMethod($id, true);
            }
            $newValue = $newValueArr;
        }
        asort($oldValue);
        asort($newValue);

        $oldValue = implode(', ', $oldValue);
        $newValue = implode(', ', $newValue);

        $changes = ChangesData::factory(
            [
                $currentPropertyTag => [
                    self::CHANGES_FROM => $oldValue,
                    self::CHANGES_TO => $newValue
                ]
            ],
            $currentObjectId
        );

        return [
            self::CHANGES_CURRENT => $changes,
            self::CHANGES_TO => $changes,
        ];
    }

    /**
     * @param string                 $tag
     * @param isys_cmdb_dao_category $dao
     * @param RequestData            $requestDataProvider
     * @param SmartyData             $smartyDataProvider
     * @param array                  $currentData
     *
     * @return array
     * @throws Exception
     * @throws \idoit\Exception\JsonException
     */
    private function handlePopupReceiver(string $tag, isys_cmdb_dao_category $dao, RequestData $requestDataProvider, SmartyData $smartyDataProvider, array $currentData = [])
    {
        $property = $this->getProperty();
        $currentObjectId = $dao->get_object_id();
        $currentObjectTitle = $dao->obj_get_title_by_id_as_string($currentObjectId);
        $currentPropertyTag = $this->getCurrentPropertyTag($dao, $tag);
        $backwardPropertyCombinedKey = (string)$property->getInfo()->getBackwardProperty();
        $uiField = $property->getUi()->getId();
        $uiHiddenField = $uiField . '__HIDDEN';
        $assignedEntries = $requestDataProvider->getByKey(C__POST__POPUP_RECEIVER) ?:
            ($requestDataProvider->getByKey($uiHiddenField) ?:
                ($requestDataProvider->getByKey($uiField) ?: null));
        $backwardProperty = $this->loadBackwardProperty((string) $backwardPropertyCombinedKey);
        $currentEntriesAsIds = $newEntriesAsIds = $toChanges = $fromChanges = $newValue = $oldValue = [];

        if (isys_format_json::is_json_array($assignedEntries)) {
            $assignedEntries = isys_format_json::decode($assignedEntries);
        }

        $currentEntries = $dao->getAttachedEntries($currentObjectId);

        if (is_array($assignedEntries) && !empty($assignedEntries)) {
            $currentEntriesAsIds = CollectionDataExtractor::extractPropertyAsArray('id', $currentEntries);
            $newEntries = $dao->getAttachedEntries($assignedEntries, $tag);
            $newEntriesAsIds = CollectionDataExtractor::extractPropertyAsArray('id', $newEntries);
            // Retrieve objectids
            $objectIds = array_unique(CollectionDataExtractor::extractPropertyAsArray('objectid', $newEntries));

            foreach ($newEntries->getEntries() as $entry) {
                $newValue[] = $entry->getTitle();

                if (!$entry instanceof Entry || !$backwardProperty instanceof SinglePropertyData) {
                    continue;
                }

                if (!in_array($entry->getEntryid(), $currentEntriesAsIds)) {
                    $toChanges[] = $this->processBackwardsEntryPropertyChange(
                        $currentObjectId,
                        $currentObjectTitle,
                        $entry,
                        $backwardProperty,
                        self::CHANGES_TO
                    );
                }
            }
        }

        foreach ($currentEntries->getEntries() as $entry) {
            $oldValue[] = $entry->getTitle();

            if (!$entry instanceof Entry || !$backwardProperty instanceof SinglePropertyData) {
                continue;
            }

            if (!in_array($entry->getEntryid(), $newEntriesAsIds)) {
                $fromChanges[] = $this->processBackwardsEntryPropertyChange(
                    $currentObjectId,
                    $currentObjectTitle,
                    $entry,
                    $backwardProperty,
                    self::CHANGES_FROM
                );
            }
        }

        $changes = ChangesData::factory(
            [
                $currentPropertyTag => [
                    self::CHANGES_FROM => implode(', ', $oldValue),
                    self::CHANGES_TO => implode(', ', $newValue)
                ]
            ],
            $currentObjectId
        );

        return [
            self::CHANGES_CURRENT => $changes,
            self::CHANGES_TO => $toChanges,
            self::CHANGES_FROM => $fromChanges
        ];
    }

    public function handleRanking()
    {
        // TODO: Implement handleRanking() method.
    }

    public function handleData(DefaultData $currentData, DefaultData $changedData)
    {
        // TODO: Implement handleData() method.
    }

    /**
     * @param string                 $tag
     * @param isys_cmdb_dao_category $dao
     *
     * @return ChangesData|null
     */
    public function getChangesWithDefaults(string $tag, isys_cmdb_dao_category $dao)
    {
        $property = $this->getProperty();
        $defaultValue =$property->getUi()->getDefault();
        $currentObjectId = $dao->get_object_id();
        $currentPropertyTag = $this->getCurrentPropertyTag($dao, $tag);

        return ChangesData::factory(
            [
                $currentPropertyTag => [
                    self::CHANGES_FROM => '',
                    self::CHANGES_TO => $defaultValue
                ]
            ],
            $currentObjectId
        );
    }
}
