[{isys_group name="tom.popup.custom-fields"}]
<div id="custom-fields-attribute-configuration-popup">
    <h3 class="popup-header">
        <img class="fr mouse-pointer popup-closer" alt="x" src="[{$dir_images}]icons/close-circle.png">
        <span>[{isys type="lang" ident="LC__SYSTEM__CUSTOM_CATEGORIES__PROPERTY"}] "[{$propertyTitle|escape:"html"}]"</span>
    </h3>

    <div class="popup-content">
        <table class="w100">
            <tr>
                <td class="label-key">[{isys type="f_label" name="field_type" ident="LC__SYSTEM__CUSTOM_CATEGORIES__FIELD_TYPE"}]</td>
                <td>[{isys name="field_type" type="f_dialog"}]</td>
            </tr>
            <tr class="notice hide">
                <td></td>
                <td>
                    <div class="box-blue p5 mr20 ml20">
                        <img src="/idoit/images/icons/silk/information.png" class="vam mr5">
                        <span class="van"><!-- Will be filled by JS --></span>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="label-key">[{isys type="f_label" name="field_title" ident="LC__SYSTEM__CUSTOM_CATEGORIES__FIELD_TITLE"}]</td>
                <td>
                    [{isys name="field_title" type="f_text"}]
                    <div class="ml20 mr20">
                        [{isys name="field_title_multiline" type="f_textarea"}]
                    </div>
                </td>
            </tr>
            <tr>
                <td class="label-key">[{isys type="lang" ident="LC__SYSTEM__CUSTOM_CATEGORIES__FIELD_ADDITIONAL"}]</td>
                <td>
                    [{isys name="field_identifier" type="f_text"}]
                    [{isys name="field_dialog_default" type="f_dialog"}]
                    [{isys name="field_relation" type="f_dialog"}]
                </td>
            </tr>
            <tr class="dependency-field hide">
                <td class="label-key">
                    <img src="[{$dir_images}]icons/silk/information.png" class="mr5 vam mouse-help" title="[{isys type="lang" ident="LC__SYSTEM__CUSTOM_CATEGORIES__DEPENDENCY_INFO"|escape:"html"}]" />
                    [{isys type="f_label" name="field_dialog_dependency" ident="LC__SYSTEM__CUSTOM_CATEGORIES__DEPENDENCY"}]
                </td>
                <td>[{isys name="field_dialog_dependency" type="f_dialog"}]</td>
            </tr>
            <tr class="dependency-field hide">
                <td class="label-key">[{isys type="f_label" name="field_dialog_linked_to" ident="LC__SYSTEM__CUSTOM_CATEGORIES__LINKED_TO"}]</td>
                <td>[{isys name="field_dialog_linked_to" type="f_dialog"}]</td>
            </tr>
            <tr>
                <td class="label-key">[{isys type="f_label" name="field_visibility" ident="LC__SYSTEM__CUSTOM_CATEGORIES__FIELD_HANDLING"}]</td>
                <td>[{isys name="field_visibility" type="f_dialog"}]</td>
            </tr>
            [{if $isMultivalueCategory}]
            <tr>
                <td class="label-key">[{isys type="lang" ident="LC__SYSTEM__CUSTOM_CATEGORIES__SHOW_IN_LIST"}]</td>
                <td><input type="checkbox" name="field_show_in_list" value="1" [{if $showInLine}]checked="checked"[{/if}] /></td>
            </tr>
            [{/if}]
        </table>
    </div>

    <div class="popup-footer">
        <button type="button" class="btn fr mr5 delete-configuration">
            <img src="[{$dir_images}]icons/silk/bin_empty.png" class="mr5" />
            <span>[{isys type="lang" ident="LC__SYSTEM__CUSTOM_CATEGORIES__FIELD_REMOVE"}]</span>
        </button>

        <button type="button" class="btn mr5 save-configuration">
            <img src="[{$dir_images}]icons/silk/disk.png" class="mr5" />
            <span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span>
        </button>

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]icons/silk/cross.png" class="mr5" />
            <span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        const $popup = $('custom-fields-attribute-configuration-popup');

        idoit.Require
            .addModule('custom-fields.attribute-configuration-popup', '[{isys_module_custom_fields::getWwwPath()}]assets/js/attribute-configuration-popup.js')
            .require('custom-fields.attribute-configuration-popup', function () {
                const configPopup = new window.AttributeConfigurationPopup($popup, {
                    dialogYesNoDefaults: JSON.parse('[{$dialogYesNoDefaults|json_encode|escape:"javascript"}]'),
                    calendarDefaults: JSON.parse('[{$calendarDefaults|json_encode|escape:"javascript"}]'),
                    singleLineFields: JSON.parse('[{$singleLineFields|json_encode|escape:"javascript"}]')
                });

                $popup.on('click', '.popup-closer', function () {
                    popup_close();
                });

                $popup.on('click', '.save-configuration', function () {
                    const configuration = configPopup.getConfiguration();
                    configuration.key = '[{$key}]';

                    $('area').fire('field:update', configuration);
                    popup_close();
                });

                $popup.on('click', '.delete-configuration', function () {
                    $('area').fire('field:remove', { key: '[{$key}]' });
                    popup_close();
                });
            });
    })();
</script>
<style>
    #custom-fields-attribute-configuration-popup table tr {
        height: 30px;
    }

    #custom-fields-attribute-configuration-popup table td:first-child {
        width: 120px;
        text-align: right;
    }

    #custom-fields-attribute-configuration-popup input[type="checkbox"] {
        margin-left: 20px;
    }
</style>
[{/isys_group}]
