<?php

namespace idoit\Module\QCW\Model;

use idoit\Model\Dao\Base;

/**
 * i-doit QCW category Model.
 *
 * @package     Modules
 * @subpackage  QCW
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Category extends Base
{
    /**
     * Blacklisted global categories.
     *
     * @var array
     */
    protected $globalBlacklist = [
        'C__CATG__GLOBAL',
        'C__CATG__RELATION',
        'C__CATG__LOGBOOK',
        'C__CATG__PLANNING',
        'C__CATG__VIRTUAL_AUTH',
        'C__CATG__OVERVIEW',
        'C__CATG__CUSTOM_FIELDS',
        'C__CATG__MULTIEDIT'
    ];

    /**
     * Blacklisted specific categories.
     *
     * @var array
     */
    protected $specificBlacklist = [];

    /**
     * Method for loading specific categories.
     *
     * @param null $idConst
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function loadSpecific($idConst = null)
    {
        $condition = '';

        if ($idConst !== null) {
            if (is_numeric($idConst)) {
                $condition = 'AND isysgui_cats__id = ' . $this->convert_sql_id($idConst);
            } else {
                $condition = 'AND isysgui_cats__const = ' . $this->convert_sql_text($idConst);
            }
        } elseif (count($this->specificBlacklist)) {
            $condition = 'AND isysgui_cats__id ' . $this->prepare_in_condition($this->specificBlacklist, true);
        }

        return $this->retrieve('SELECT *
            FROM isysgui_cats
            WHERE isysgui_cats__parent IS NULL
            ' . $condition . ';');
    }

    /**
     * Method for loading global categories.
     *
     * @param  mixed $idConst May be the ID or constant.
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function loadGlobal($idConst = null)
    {
        $condition = '';

        if ($idConst !== null) {
            if (is_numeric($idConst)) {
                $condition = 'AND isysgui_catg__id = ' . $this->convert_sql_id($idConst);
            } else {
                $condition = 'AND isysgui_catg__const = ' . $this->convert_sql_text($idConst);
            }
        } elseif (count($this->globalBlacklist)) {
            $condition = 'AND isysgui_catg__id ' . $this->prepare_in_condition($this->globalBlacklist, true);
        }

        return $this->retrieve('SELECT *
            FROM isysgui_catg
            WHERE isysgui_catg__parent IS NULL
            ' . $condition . ';');
    }

    /**
     * Method for loading global categories.
     *
     * @param  mixed $idConst May be the ID or constant.
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function loadCustom($idConst = null)
    {
        $condition = '';

        if ($idConst !== null) {
            if (is_numeric($idConst)) {
                $condition = 'WHERE isysgui_catg_custom__id = ' . $this->convert_sql_id($idConst);
            } else {
                $condition = 'WHERE isysgui_catg_custom__const = ' . $this->convert_sql_text($idConst);
            }
        }

        return $this->retrieve('SELECT *
            FROM isysgui_catg_custom
            ' . $condition . ';');
    }
}
