[{isys_group name="tom.popup.qcw"}]
<div id="popup-qcw">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__MODULE__QCW__POPUP__HEADER"}] [{isys type="lang" ident="LC__MODULE__QCW__POPUP__HEADER_SUFFIX_OBJECT_TYPES"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img alt="close" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

	<div class="popup-content"></div>

	<div class="popup-footer-ng">
		<button type="button" class="btn mr5" data-action="accept">
			<img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span>
		</button>
		<button type="button" class="btn popup-closer">
			<img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
		</button>
	</div>
</div>

<script type="text/javascript">
	idoit.Translate.set('LC_UNIVERSAL__ACCEPT', '[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]');
	idoit.Translate.set('LC__UNIVERSAL__SEARCH', '[{isys type="lang" ident="LC__UNIVERSAL__SEARCH"}]');
	idoit.Translate.set('LC__MODULE__QCW__POPUP__NEW_ITEM', '[{isys type="lang" ident="LC__MODULE__QCW__POPUP__NEW_ITEM"}]');
	idoit.Translate.set('LC__MODULE__QCW__POPUP__DELETE', '[{isys type="lang" ident="LC__MODULE__QCW__POPUP__DELETE" p_bHtmlEncode=false}]');
	idoit.Translate.set('LC__UNIVERSAL__EDIT', '[{isys type="lang" ident="LC__UNIVERSAL__EDIT"}]');
	idoit.Translate.set('LC__UNIVERSAL__TITLE', '[{isys type="lang" ident="LC__UNIVERSAL__TITLE"}]');
	idoit.Translate.set('LC__CMDB__OBJTYPE__CONST', '[{isys type="lang" ident="LC__CMDB__OBJTYPE__CONST"}]');
	idoit.Translate.set('LC__UNIVERSAL__COLOR', '[{isys type="lang" ident="LC__UNIVERSAL__COLOR"}]');
	idoit.Translate.set('LC__MODULE__QCW__SHOWN', '[{isys type="lang" ident="LC__MODULE__QCW__POPUP__OBJECT_TYPE_SHOW"}]');
	idoit.Translate.set('LC__MODULE__QCW__HIDDEN', '[{isys type="lang" ident="LC__MODULE__QCW__POPUP__OBJECT_TYPE_HIDE"}]');
	idoit.Translate.set('LC__MODULE__QCW__POPUP__EDIT_DISABLED', '[{isys type="lang" ident="LC__MODULE__QCW__POPUP__EDIT_DISABLED" p_bHtmlEncode=false}]');
	idoit.Translate.set('LC__MODULE__QCW__POPUP__DELETE_DISABLED', '[{isys type="lang" ident="LC__MODULE__QCW__POPUP__DELETE_DISABLED" p_bHtmlEncode=false}]');
	idoit.Translate.set('LC__MODULE__QCW__POPUP__CREATE', '[{isys type="lang" ident="LC__MODULE__QCW__POPUP__CREATE"}]');
	idoit.Translate.set('LC_UNIVERSAL__ABORT', '[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]');
	idoit.Translate.set('LC__MODULE__QCW__BUTTON_APPLY', '[{isys type="lang" ident="LC__MODULE__QCW__BUTTON_APPLY"}]');
	idoit.Translate.set('LC__CMDB__OBJTYPE__CATS', '[{isys type="lang" ident="LC__CMDB__OBJTYPE__CATS"}]');
	idoit.Translate.set('LC__MODULE__QCW__LOCATION_OBJECT', '[{isys type="lang" ident="LC__MODULE__QCW__LOCATION_OBJECT"}]');
	idoit.Translate.set('LC__CMDB__OBJTYPE__INSERTION_OBJECT', '[{isys type="lang" ident="LC__CMDB__OBJTYPE__INSERTION_OBJECT"}]');
	idoit.Translate.set('LC__UNIVERSAL__NO', '[{isys type="lang" ident="LC__UNIVERSAL__NO"}]');
	idoit.Translate.set('LC__UNIVERSAL__YES', '[{isys type="lang" ident="LC__UNIVERSAL__YES"}]');
	idoit.Translate.set('LC__MODULE__QCW__POPUP__LC_TITLE', '[{isys type="lang" ident="LC__MODULE__QCW__POPUP__LC_TITLE" p_bHtmlEncode=false}]');
	idoit.Translate.set('LC__MODULE__QCW__POPUP__DEFAULT_TEMPLATE', '[{isys type="lang" ident="LC__MODULE__QCW__POPUP__DEFAULT_TEMPLATE"}]');

	// Chosen.
	idoit.Translate.set('LC__UNIVERSAL__CHOOSEN_PLACEHOLDER', '[{isys type="lang" ident="LC__UNIVERSAL__CHOOSEN_PLACEHOLDER" p_bHtmlEncode=false}]');
	idoit.Translate.set('LC__UNIVERSAL__CHOOSEN_PLACEHOLDER', '[{isys type="lang" ident="LC__UNIVERSAL__CHOOSEN_PLACEHOLDER" p_bHtmlEncode=false}]');
	idoit.Translate.set('LC__UNIVERSAL__CHOOSEN_EMPTY', '[{isys type="lang" ident="LC__UNIVERSAL__CHOOSEN_EMPTY" p_bHtmlEncode=false}]');

	[{include file="`$assetsDir`js/popup.js"}]

	(function () {
		'use strict';

		try
		{
			var data           = '[{$data|escape:"javascript"}]'.evalJSON(),
			    additionalData = '[{$additionalData|escape:"javascript"}]'.evalJSON();
		}
		catch (e)
		{
			idoit.Notify.error('Error while encoding JSON: ' + e, {sticky: true});

			popup_close();
		}

		var popup = new QCWObjectTypePopup($('popup-qcw'), data, {
			ajaxUrl:                  '[{$ajax_url}]',
			context:                  '[{$context}]',
			createItemHeader:         '[{isys type="lang" ident="LC__MODULE__QCW__POPUP__CREATE_OBJECT_TYPE" p_bHtmlEncode=false}]',
			editItemHeader:           '[{isys type="lang" ident="LC__MODULE__QCW__POPUP__EDIT_OBJECT_TYPE" p_bHtmlEncode=false}]',
			deleteItemConfirmMessage: '[{isys type="lang" ident="LC__MODULE__QCW__DELETE_OBJTYPEGROUPS" p_bHtmlEncode=false}]',
			additionalData:           additionalData,
			afterRender:              function () {
				this.colorpicker = new jscolor.color(this.$form.down('[data-mapping="color"]'), {hash: false});

				this.$form.select('.chosen-select').each(function($select) {
					new Chosen($select.enable(), {
						default_multiple_text:     idoit.Translate.get('LC__UNIVERSAL__CHOOSEN_PLACEHOLDER'),
						placeholder_text_multiple: idoit.Translate.get('LC__UNIVERSAL__CHOOSEN_PLACEHOLDER'),
						no_results_text:           idoit.Translate.get('LC__UNIVERSAL__CHOOSEN_EMPTY'),
						disable_search_threshold:  10,
						search_contains:           true
					});
				});
			},
			onEdit:                   function (ev, data) {
				this.colorpicker.fromString(data.color || 'FFFFFF');
			},
			onEditCancel:             function () {
				this.colorpicker.fromString('FFFFFF');
				this.$form.down('[data-mapping="cats"]').setValue('-1').simulate('change').fire('chosen:updated');
			},
			onNewCancel:              function () {
				this.colorpicker.fromString('FFFFFF');
				this.$form.down('[data-mapping="cats"]').setValue('-1').simulate('change').fire('chosen:updated');
			},
			onToggleVisibility:       function (ev, data) {
				var $li = ev.findElement('li'),
					$title = $li.down('.title');

				data.detached = !data.visible;

				if (data.visible) {
					$title.down('span').addClassName('text-strike');
				} else {
					$title.down('span').removeClassName('text-strike');
				}
			},
			onPopupAccept: function () {
				$('obj_type_list').fire('list:updated', {
					callback: function () {
						this.currentObjectTypeGroup = null;
						this.$objTypeGroupList.down('li.active').simulate('click');
					}
				});
			}
		});
	})();
</script>
[{/isys_group}]
