<ul class="list-style-none m10"></ul>
<div id="canvas_[{$unique_id}]" class="cb"></div>

<style type="text/css">
	#[{$unique_id}] li {
		float: left;
		margin-right: 15px;
		cursor: pointer;
	}

	#[{$unique_id}] li.filtered {
		font-weight: bold;
	}

	#canvas_[{$unique_id}] {
		width:100%;
		height:400px;
		background-color: #fff;
	}

	#canvas_[{$unique_id}] text {
		font-size: 15px;
	}

	#canvas_[{$unique_id}] .arc,
	#canvas_[{$unique_id}] .bar {
		transition: opacity 500ms;
		-moz-transition: opacity 500ms;
		-webkit-transition: opacity 500ms;
	}

	#canvas_[{$unique_id}] .filtered {
		opacity: 0.25;
	}
</style>

<script type="text/javascript">
    (function () {
        'use strict';

        idoit.Require.require(['d3'], function () {
            var data        = '[{$object_types|json_encode|escape:"javascript"}]'.evalJSON(),
                chartType   = '[{$chart_type}]',
                $canvas     = $('canvas_[{$unique_id}]'),
                $canvasList = $('[{$unique_id}]').down('ul'),
                chart,
                chartClass,
                i;

            switch (chartType) {
                case 'Pie':
                case 'Donut':
                    chartClass = 'd3ChartPie';
                    break;

                case 'Bar':
                case 'SideBar':
                    chartClass = 'd3ChartBar';
                    break;

                case 'StackedBar':
                case 'SideStackedBar':
                    chartClass = 'd3ChartStacked';
                    break;
            }

            if (! chartClass) {
                idoit.Notify.warning('[{isys type="lang" ident="LC__WIDGET__STATS__ERROR_NO_TYPE"}]', {life: 5});

	            return;
            }

            idoit.Require.require(chartClass, function () {
                switch (chartType) {
                    case 'Pie':
                        chart = new window.D3ChartPie($canvas, {hideLabelsLessThan: 2.5});
                        break;

                    case 'Donut':
                        chart = new window.D3ChartPie($canvas, {showPercentageInCenter:true, innerRadius: 75, hideLabelsLessThan: 2.5});
                        break;

                    case 'Bar':
                        chart = new window.D3ChartBar($canvas);
                        break;

                    case 'SideBar':
                        chart = new window.D3ChartBar($canvas, {vertical: false});
                        break;

                    case 'StackedBar':
                        chart = new window.D3ChartStacked($canvas);
                        break;

                    case 'SideStackedBar':
                        chart = new window.D3ChartStacked($canvas, {vertical: false});
                        break;
                }

	            // Sort the data (from big numbers to small ones).
	            data.sort(function (a, b) {
	                return b.count - a.count;
	            });

	            // Fill the chart with data (but remove empty items).
	            chart.setData(data.filter(function (d) { return d.count > 0; }));

	            $canvas.on('render:chart', function () {
	                chart.updateDimension().update();
	            });

	            [{if $legend}]
	            // Create the legend.
	            for (i in data) {
	                if (!data.hasOwnProperty(i)) {
	                    continue;
	                }

	                $canvasList
	                    .insert(new Element('li', {title: data[i].count, 'data-id': data[i].id})
	                        .update(new Element('div', {className: 'cmdb-marker mr5', style: 'background-color:' + data[i].color + ';'}))
	                        .insert(new Element('span').update(data[i].title)))
	            }

	            $canvasList.on('click', 'li', function (ev) {
	                var $li          = ev.findElement('li'),
	                    objectTypeId = $li.readAttribute('data-id');

	                if ($li.hasClassName('filtered')) {
	                    $li.removeClassName('filtered');

	                    chart.unfilter();
	                } else {
	                    $canvasList.select('li.filtered').invoke('removeClassName', 'filtered');

	                    $li.addClassName('filtered');

	                    chart.filter(objectTypeId);
	                }
	            });
		        [{/if}]

                $canvas.fire('render:chart');
            });
        });
    })();
</script>