<?php

/**
 * i-doit
 *
 * Pro module class.
 *
 * @package     i-doit
 * @subpackage  modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_pro extends isys_module
{
    // Define, if this module shall be displayed in the named menus.
    const DISPLAY_IN_MAIN_MENU   = false;
    const DISPLAY_IN_SYSTEM_MENU = false;
    const MAIN_MENU_REWRITE_LINK = false;

    /**
     * @return void
     */
    public function start()
    {
        // Nothing to do
    }

    /**
     * Initializes the module.
     *
     * @param isys_module_request $p_req
     */
    public function init(isys_module_request $p_req)
    {
        // Nothing to do
    }

    /**
     * @param isys_component_tree $tree
     * @param int $parent
     */
    public static function extendCmdbSettingsTree(isys_component_tree $tree, int $parent)
    {
        $language = isys_application::instance()->container->get('language');

        if (isys_module_cmdb::getAuth()->is_allowed_to(isys_auth::VIEW, 'attribute_visibility')) {
            $currentCount = $tree->count() + 1;

            $tree->add_node(
                $currentCount,
                $parent,
                $language->get('LC__CMDB__TREE__SYSTEM__ATTRIBUTE_VISIBILITY'),
                isys_module_system::generate_link('attributeVisibility', $currentCount),
                '',
                'images/axialis/basic/zoom.svg',
                $_GET['what'] === 'attributeVisibility'
            );
        }

        if (isys_module_system::getAuth()->is_allowed_to(isys_auth::VIEW, 'custom-translations')) {
            $currentCount = $tree->count() + 1;

            $tree->add_node(
                $currentCount,
                $parent,
                $language->get('LC__CUSTOM_TRANSLATIONS'),
                isys_module_system::generate_link('custom-translations', $currentCount),
                '',
                'images/axialis/flags-languages/application-language.svg',
                $_GET['what'] === 'custom-translations'
            );
        }
    }
}
