<?php

namespace idoit\Module\Pro\Algorithm\Formatter;

use isys_component_database;
use isys_component_template_language_manager;

/**
 * Class AbstractFormatter
 *
 * @package idoit\Module\Pro\Algorithm\Formatter
 */
abstract class AbstractFormatter implements FormatterInterface
{
    /**
     * @var isys_component_database
     */
    protected $database;

    /**
     * @var isys_component_template_language_manager
     */
    protected $language;

    /**
     * AbstractFormatter constructor.
     *
     * @param isys_component_database                  $database
     * @param isys_component_template_language_manager $language
     */
    public function __construct(isys_component_database $database, isys_component_template_language_manager $language)
    {
        $this->database = $database;
        $this->language = $language;
    }
}
