<?php

use idoit\Module\QCW\Model\ObjectTypeGroup;

/**
 * i-doit
 *
 * QCW object type group adjuster popup.
 *
 * @package     Modules
 * @subpackage  QCW
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.8.0
 */
class isys_popup_qcw_adjust_object_type_group extends isys_popup_qcw_adjust
{
    /**
     * Handle specific ajax requests.
     *
     * @param   isys_module_request $p_modreq
     *
     * @return  mixed
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function &handle_ajax_request(isys_module_request $p_modreq)
    {
        header('Content-Type: application/json');

        $response = [
            'success' => true,
            'data'    => null,
            'message' => null
        ];

        try {
            switch ($_POST['action']) {
                case 'save':
                    $dao = ObjectTypeGroup::instance($this->database);

                    $response['data'] = array_merge(
                        $dao->saveMultiple(isys_format_json::decode($_POST['data'])),
                        $dao->deleteMultiple(isys_format_json::decode($_POST['deleted']))
                    );

                    if ($dao->getCreateCounter() || $dao->getDeleteCounter()) {
                        $this->clear_system_cache();
                    }
                    break;
            }
        } catch (Exception $e) {
            $response['success'] = false;
            $response['message'] = $e->getMessage();
        }

        echo \isys_format_json::encode($response);
        die;
    }

    /**
     * Method for handling the module request.
     *
     * @param   isys_module_request $p_modreq
     *
     * @return  null
     * @throws isys_exception_database
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        parent::handle_module_request($p_modreq);

        $objectTypeGroups = [];

        $i = 0;
        $res = ObjectTypeGroup::instance($this->database)->load();

        if (count($res)) {
            while ($row = $res->get_row()) {
                $objectTypeGroups[$this->language->get($row['isys_obj_type_group__title']) . (++$i)] = [
                    'id'            => $row['isys_obj_type_group__id'],
                    'const'         => $row['isys_obj_type_group__const'],
                    'title'         => $this->language->get($row['isys_obj_type_group__title']),
                    'titleOrig'     => $row['isys_obj_type_group__title'],
                    'visible'       => $row['isys_obj_type_group__status'] == C__RECORD_STATUS__NORMAL,
                    'disableDelete' => strpos($row['isys_obj_type_group__const'], 'C__OBJTYPE_GROUP__SD_') !== 0,
                    'selfdefined'   => strpos($row['isys_obj_type_group__const'], 'C__OBJTYPE_GROUP__SD_') === 0
                ];
            }

            ksort($objectTypeGroups);
        }

        $this->template->assign('data', isys_format_json::encode(array_values($objectTypeGroups)))
            ->display(isys_module_quick_configuration_wizard::getPath() . 'templates/popup/popupQcwAdjustObjectTypeGroup.tpl');

        die;
    }
}
