window.AttributeVisibility = Class.create({
    config: {},
    
    initialize: function(config, options) {
        this.config = config;
    
        this.options = {
            categoryConstant: '',
            parentElementType: 'tr',
            selectedAttributeFromConfig: 'uId',
            searchPattern: 'input[name*="%s"]',
            itemNamePattern: '%s'
        };
    
        Object.extend(this.options, options || {});
    },
    
    ajaxHideAttributes: function() {
        new Ajax.Request(window.www_dir + 'system/ajaxAttributeVisibility/loadConfig', {
            method:     'post',
            parameters: {
                categoryConstant: this.options.categoryConstant
            },
            onSuccess:  function (transport) {
                var json = transport.responseJSON;

                if (!is_json_response(transport, true)) {
                    return;
                }

                if (json.data) {
                    this.config = json.data;
                    this.hideAttributes();
                }
            }.bind(this)
        });
    },
    
    hideAttributes: function() {
        let item, itemName, itemElement, type, searchPattern, searchItem;
        
        this.config.forEach((item) => {
            itemName = this.options.itemNamePattern;
            searchPattern = this.options.searchPattern;
            searchItem = searchPattern.replace('%s',
                itemName.replace('%s', item[this.options.selectedAttributeFromConfig])
            );
            itemElement = $('scroller').down(searchItem);
            
            if (itemElement) {
                if (itemElement.up(this.options.parentElementType)) {
                    itemElement.up(this.options.parentElementType).hide();
                } else {
                    itemElement.up().hide();
                }
            }
        });
    },
});