<?php

namespace idoit\Module\JDisc\Graphql\Mutation\Discovery;

use GraphQL\Mutation;
use GraphQL\Query;
use GraphQL\Results;
use idoit\Module\JDisc\Graphql\AbstractGraphql;
use idoit\Module\JDisc\Graphql\ParameterBagInterface;
use idoit\Module\JDisc\Graphql\ResponseInterface;
use idoit\Module\JDisc\Graphql\Type\AbstractType;
use idoit\Module\JDisc\Graphql\Type\DiscoveryJobReferenceType;

class StopJob extends AbstractGraphql implements ParameterBagInterface, ResponseInterface
{
    private DiscoveryJobReferenceType $discoveryJobReference;

    /**
     * @param DiscoveryJobReferenceType $discoveryJobReference
     */
    public function setDiscoveryJobReference(DiscoveryJobReferenceType $discoveryJobReference): void
    {
        $this->discoveryJobReference = $discoveryJobReference;
    }

    /**
     * @return array
     */
    public function getSelections(): array
    {
        return [];
    }

    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        $query = (new Mutation('discovery'))
            ->setVariables($this->buildVariables())
            ->setSelectionSet(
                [
                    (new Query('control'))
                        ->setSelectionSet(
                            [
                                (new Query('stopJob'))
                                    ->setArguments($this->buildArguments())
                            ]
                        )
                ]
            );

        return $query;
    }

    /**
     * @return DiscoveryJobReferenceType[]
     */
    public function getParameters() : array
    {
        return [
            $this->discoveryJobReference
        ];
    }

    /**
     * @param Results $results
     *
     * @return array
     */
    public static function getDataFromResults(Results $results): array
    {
        $data = $results->getData();
        return $data['discovery']['control'];
    }
}