<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ClusterInput
 * A cluster object. * @property null|bool $allMembersFound = null A flag whether all cluster members have been found.
 * @property null|iterable|DeviceInputInputType[] $associatedVirtualMachines = null The associated cluster member virtual machines.
Note, that this is not the list of VMs running in this cluster.
It is more a configuration item in some virtualization environments (e.g. XenServer). You can associate a VM with a cluster
and then the cluster decides on which physical host of the cluster the VM gets started.
 * @property null|iterable|DeviceInputInputType[] $clusterMembers = null The cluster member devices
 * @property null|string $name = null The cluster name.
 * @property null|ClusterTypeEnum $type = null The cluster type
 * @property null|string $uniqueId = null A cluster's unique id.
 * @property null|VirtualDatacenterInputInputType $virtualDatacenter = null The virtual datacenter that a cluster belongs to.
 */
final class ClusterInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'associatedVirtualMachines') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'clusterMembers') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'type') {
            return new ClusterTypeEnum($value);
        }

        if ($name === 'virtualDatacenter') {
            return new VirtualDatacenterInputInputType($value);
        }

        return $value;
    }
}