<?php

namespace idoit\Module\Console\Steps\Addon;

use idoit\Module\Console\Steps\Message\ErrorLevel;
use idoit\Module\Console\Steps\Message\Messages;
use idoit\Module\Console\Steps\Message\StepMessage;
use idoit\Module\Console\Steps\Step;

class ExtractAddonIdentifierFromPackage implements Step
{
    /**
     * @var callable
     */
    private $callback;

    /**
     * @var string
     */
    private $path;

    /**
     * InstallAddonByPackage constructor.
     *
     * @param string   $path
     * @param callable $callback - callback to be called with the extracted identifier
     */
    public function __construct(string $path, callable $callback)
    {
        $this->path = $path;
        $this->callback = $callback;
    }

    /**
     * Get name of the step
     *
     * @return string
     */
    public function getName()
    {
        return 'Search add-on in ' . $this->path;
    }

    /**
     * Process the work
     *
     * @param Messages $messages
     *
     * @return mixed
     */
    public function process(Messages $messages)
    {
        // @see  ID-8566  Check for any package.json files.
        $addonPackageFile = $this->path . '/package.json';
        $bundlePackageFiles = glob($this->path . '/package-*.json');

        // Go sure that we have an array of package files.
        if (!is_array($bundlePackageFiles)) {
            $bundlePackageFiles = [];
        }

        if (empty($bundlePackageFiles) && file_exists($addonPackageFile)) {
            $bundlePackageFiles[] = $addonPackageFile;
        }

        if (count($bundlePackageFiles) === 0) {
            return false;
        }

        foreach ($bundlePackageFiles as $bundlePackageFile) {
            $package = json_decode(file_get_contents($bundlePackageFile), true);

            if (!is_array($package) || ($package['type'] ?? '') !== 'addon' || !isset($package['identifier'])) {
                $messages->addMessage(new StepMessage($this, 'package file does not contain the valid package information', ErrorLevel::ERROR));

                return false;
            }

            if (!call_user_func($this->callback, $bundlePackageFile, $package['identifier'], $messages)) {
                return false;
            }
        }

        return true;
    }
}
