<?php

/**
 * i-doit
 *
 * JDisc data module DAO
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Van Quyen Hoang <qhoang@i-doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.5
 */
class isys_jdisc_dao_discovery
{
    /**
     * singleton holder
     * @var isys_jdisc_dao_discovery
     */
    protected static $m_instance = null;

    /**
     * JDisc current discovery job
     *
     * @var string
     */
    protected $m_discovery_job = null;

    /**
     * JDisc Connection Session ID
     *
     * @var array
     */
    protected $m_sessionID = null;

    /**
     * Connector
     *
     * @var isys_protocol_soap
     */
    protected $m_soap_connector = null;

    /**
     * Request options
     *
     * @var array
     */
    protected $m_soap_request_options = [];

    /**
     * JDisc hostaddress or hostname of the device which shall be discovered
     *
     * @var string
     */
    protected $m_target = null;

    /**
     * Singelton
     *
     * @return isys_jdisc_dao_discovery
     */
    public static function get_instance($id)
    {
        if (empty(self::$m_instance)) {
            $id = (int) $id;
            if (isys_module_jdisc::factory()->isGraphqlAvailable($id)) {
                self::$m_instance = (new isys_jdisc_dao_discovery_graphql())->setServerId($id);
            } else {
                self::$m_instance = new isys_jdisc_dao_discovery_soap();
            }
        }

        return self::$m_instance;
    }

    /**
     * Getter for the discovery job
     *
     * @return string
     */
    public function get_discovery_job()
    {
        return $this->m_discovery_job;
    }

    /**
     * Setter for the discovery job
     *
     * @param $p_job
     *
     * @return $this
     */
    public function set_discovery_job($p_job)
    {
        $this->m_discovery_job = $p_job;

        return $this;
    }

    /**
     * Setter for the device discover target
     *
     * @param $p_value
     *
     * @return $this
     */
    public function set_target($p_value)
    {
        $this->m_target = $p_value;

        return $this;
    }

    /**
     * Getter for the device discovery target
     *
     * @return string
     */
    public function get_target()
    {
        return $this->m_target;
    }

    /**
     * Function for disconnecting from the Host
     *
     * @return $this
     * @throws Exception
     * @throws isys_exception_general
     */
    public function disconnect()
    {
        return $this;
    }

    /**
     * Method to connect to the Host via SOAP
     *
     * @param        $p_host
     * @param        $p_username
     * @param        $p_password
     * @param string $p_port
     * @param string $p_protocol
     *
     * @return $this
     * @throws Exception
     * @throws isys_exception_general
     */
    public function connect($p_host, $p_username, $p_password, $p_port = '9000', $p_protocol = 'http')
    {
        return $this;
    }

    /**
     * Gets all discovery jobs as html options
     *
     * @deprecated use src/classes/modules/jdisc/src/Graphql/Query/Job/GetJobs.php instead
     *
     * @throws Exception
     */
    public function get_discovery_jobs()
    {
        return $this;
    }

    /**
     * Method for starting a discovery job
     *
     * @deprecated use src/classes/modules/jdisc/src/Graphql/Mutation/Discovery/StartJob.php
     *
     * @return bool
     * @throws Exception
     * @throws isys_exception_general
     */
    public function start_discovery_job()
    {
        return false;
    }

    /**
     * Method to trigger a discovery to the specified target device
     *
     * @deprecated use instead src/classes/modules/jdisc/src/Graphql/Mutation/Discovery/DiscoverDevice.php
     *
     * @return bool
     * @throws Exception
     */
    public function discover_device()
    {
        return false;
    }

    /**
     * Get current running discovery log
     *
     * @return array|bool
     * @throws Exception
     *
     * @deprecated use instead src/classes/modules/jdisc/src/Graphql/Query/GetDiscoveryLog.php
     *
     */
    public function get_running_discover_status()
    {
        return false;
    }

    public function __destruct()
    {
        if ($this->m_sessionID) {
            $this->disconnect();
        }
    }
}
