[{isys_group name="tom.popup.visualization"}]
<div id="visualization-popup">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__POPUP_TITLE"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div id="visualization-popup-content" class="popup-content p5">
        <label class="p5">
            <input type="radio" name="visualization-popup-export-type" class="mr5" value="png-full" checked="checked" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__PNG_FULL"}]</span>
        </label>

        <label class="p5">
            <input type="radio" name="visualization-popup-export-type" class="mr5" value="png-cropped" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__PNG_CROPPED"}]</span>
        </label>

        <label class="p5">
            <input type="radio" name="visualization-popup-export-type" class="mr5" value="svg-full" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__SVG_FULL"}]</span>
        </label>

        <label class="p5">
            <input type="radio" name="visualization-popup-export-type" class="mr5" value="svg-cropped" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__SVG_CROPPED"}]</span>
        </label>

        <label class="p5">
            <input type="radio" name="visualization-popup-export-type" class="mr5" value="graphml" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__GRAPHML"}]</span>
        </label>
    </div>

    <div id="visualization-popup-footer" class="popup-footer-ng">
        <button type="button" class="btn mr5" id="visualization-popup-save">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT"}]</span>
        </button>

        <button type="button" class="btn popup-closer" id="visualization-popup-cancel">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL_CLOSE"}]</span>
        </button>
    </div>
</div>
<script type="text/javascript">
    (function () {
        'use strict';

        var $popup         = $('visualization-popup'),
            $content       = $('visualization-popup-content'),
            $footer        = $('visualization-popup-footer'),
            $accept_button = $('visualization-popup-save'),
            $canvas        = $('C_VISUALIZATION_CANVAS');

        $popup.select('.popup-closer').invoke('on', 'click', function () {
            popup_close();
        });

        $accept_button.on('click', function () {
            var date        = new Date(),
                export_type = $content.down('[name="visualization-popup-export-type"]:checked').getValue(),
                fileName    = 'cmdb-export_' + date.getFullYear() + '-' + ('0' + (1 + date.getMonth())).substr(-2, 2) + '-' + ('0' + date.getDate()).substr(-2, 2);

            switch (export_type) {
                case 'png-full':
                    prepareFullSvg().saveToPng({filename: fileName, scale: 2});
                    break;

                case 'png-cropped':
                    $canvas
                        .down('svg')
                        .saveToPng({filename: fileName, scale: 2});
                    break;

                case 'svg-full':
                    prepareFullSvg().saveToSvg({filename: fileName});
                    break;

                case 'svg-cropped':
                    $canvas
                        .down('svg')
                        .saveToSvg({filename: fileName});
                    break;

                case 'graphml':
                    // Trigger the download.
                    document.location.href = '[{$export_url}]' +
                        '&object=' + $F('C_VISUALIZATION_OBJ_SELECTION__HIDDEN') +
                        '&profile=' + $F('C_VISUALIZATION_PROFILE') +
                        '&service-filter=' + $F('C_VISUALIZATION_SERVICE_FILTER');
                    break;
            }
        });

        /**
         * This function will create a element which contains a 1:1 copy of the canvas' SVG.
         * Only difference is, that this element will be sized to display its content in full
         * and update the `transform="translate(...)"` values accordingly.
         *
         * @returns {*}
         */
        function prepareFullSvg() {
            var $nodes      = $canvas.select('.node'),
                $printView  = new Element('div'),
                match,
                i,
                matchRegExp = /translate\(([-\d\.]*),?\s*([-\d\.]*)\)/,
                boundingBox = {width: 200, height: 50},
                minX        = 0,
                minY        = 0,
                maxX        = 0,
                maxY        = 0;

            if ($nodes[0]) {
                try {
                    boundingBox = $nodes[0].getBBox();
                } catch (e) {
                    try {
                        // Using `getBoundingClientRect` as fallback (for example for IE 11).
                        boundingBox = $nodes[0].getBoundingClientRect();
                    } catch (e) {
                        // Do nothing, use the defaults.
                    }
                }
            }

            for (i in $nodes) {
                if (!$nodes.hasOwnProperty(i)) {
                    continue;
                }

                try {
                    match = Element.readAttribute($nodes[i], 'transform').match(matchRegExp);

                    // Get minimum X and Y coordinates.
                    minX = Math.min(minX, parseInt(match[1]));
                    minY = Math.min(minY, parseInt(match[2]));

                    // Get maximum X and Y coordinates.
                    maxX = Math.max(maxX, parseInt(match[1]));
                    maxY = Math.max(maxY, parseInt(match[2]));
                } catch (e) {
                    // Do nothing
                }
            }

            // Add the node width and height to the dimensions (will also create a nice margin).
            minX = Math.abs(minX) + (boundingBox.width * 1.5);
            minY = Math.abs(minY) + boundingBox.height;
            maxX += (boundingBox.width * 1.5);
            maxY += boundingBox.height;

            // Pass the element to D3 since it can handle SVG elements.
            $printView = d3.select($printView.update($canvas.innerHTML));

            // Select the SVG, alter some attributes (+ some attributes of the direct <g> descendants) and return the node.
            return $printView.select('svg')
                .attr('viewBox', '0 0 ' + (minX + maxX) + ' ' + (minY + maxY))
                .attr('width', (minX + maxX))
                .attr('height', (minY + maxY))
                .call(function (svg) {
                    svg.selectAll('svg > g').attr('transform', 'translate(' + minX + ',' + minY + ') scale(1)');
                })
                .node();
        }
    })();
</script>
<style>
    #visualization-popup {
        box-sizing: border-box;
        position: relative;
        height: 100%;
    }

    #visualization-popup #visualization-popup-content label {
        display: block;
    }

    #visualization-popup #visualization-popup-content table td.key {
        width: 150px;
    }
</style>
[{/isys_group}]
