<?php

namespace idoit\Component\Csv;

use isys_tenantsettings;
use League\Csv\Reader as CsvReader;
use SplFileObject;

/**
 * i-doit CSV reader.
 *
 * @package     i-doit
 * @subpackage  Component
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.13
 */
class Reader extends CsvReader
{
    /**
     * @param string        $path
     * @param string|null   $openMode
     * @param resource|null $context the resource context
     *
     * @return Reader|CsvReader
     */
    public static function createFromPath(string $path, ?string $openMode = null, $context = null)
    {
        return parent::createFromPath($path, $openMode ?: 'r+', $context)
            ->configure();
    }

    /**
     * @param  string $string
     *
     * @return self
     */
    public static function createFromString(string $string = '')
    {
        return parent::createFromString($string)->configure();
    }

    /**
     * @param  SplFileObject $file
     *
     * @return self
     */
    public static function createFromFileObject(SplFileObject $file)
    {
        return parent::createFromFileObject($file)->configure();
    }

    /**
     * @return Reader
     */
    private function configure()
    {
        return $this
            ->setOutputBOM(self::BOM_UTF8)
            ->setDelimiter(isys_tenantsettings::get('system.csv-export-delimiter', ';'));
    }
}
