<?php

/**
 * i-doit
 *
 * UI: global category for audits
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_ui_category_g_ldap_dn extends isys_cmdb_ui_category_global
{
    /**
     * @param isys_cmdb_dao_category $dao
     *
     * @return array
     * @throws isys_exception_database
     */
    public function process(isys_cmdb_dao_category $dao)
    {
        $rules = parent::process($dao);

        $sql = 'SELECT isys_ldap__id AS id
            FROM isys_cats_person_list
            INNER JOIN isys_ldap ON isys_ldap__id = isys_cats_person_list.isys_cats_person_list__isys_ldap__id
            WHERE isys_cats_person_list__isys_obj__id = ' . $dao->convert_sql_id($dao->get_object_id()) . '
            LIMIT 1;';

        $ldapServerUrl = isys_helper_link::create_url([
            C__GET__MODULE_ID     => C__MODULE__SYSTEM,
            C__GET__MODULE_SUB_ID => C__MODULE__LDAP,
            C__GET__SETTINGS_PAGE => 1,
            C__GET__TREE_NODE     => C__MODULE__LDAP . 1
        ]);

        $this->m_template
            ->assign('ldapServerUrl', $ldapServerUrl)
            ->assign('ldapServerId', $dao->retrieve($sql)->get_row_value('id'));

        return $rules;
    }
}
