<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     Modules
 * @subpackage  Custom_fields
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_custom_fields_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param string $className
     *
     * @return boolean
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/custom_fields/';
        $classMap = [
            'isys_custom_fields_dao'                           => 'dao/isys_custom_fields_dao.class.php',
            'isys_module_custom_fields_autoload'               => 'isys_module_custom_fields_autoload.class.php',
            'isys_module_custom_fields'                        => 'isys_module_custom_fields.class.php',
            'isys_popup_custom_fields_attribute_configuration' => 'src/popup/isys_popup_custom_fields_attribute_configuration.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
