<?php

namespace idoit\Component\Table\Filter\Operation;

use idoit\Component\Property\Property;
use isys_cmdb_dao_list_objects;

/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class DateOperation extends PropertyOperation
{
    /**
     * @param string $filter
     * @param string $value
     *
     * @return bool
     */
    public function isApplicable($filter, $value)
    {
        $property = $this->getProperty($filter);

        return $property[Property::C__PROPERTY__DATA][Property::C__PROPERTY__DATA__TYPE] === C__TYPE__DATE;
    }

    /**
     * Apply Property
     *
     * @param isys_cmdb_dao_list_objects $listDao
     * @param array|Property             $property
     * @param string                     $name
     * @param string                     $value
     *
     * @return mixed
     */
    protected function applyProperty(isys_cmdb_dao_list_objects $listDao, $property, $name, $value)
    {
        if (strtotime($value) !== false) {
            $fieldName = $listDao->get_database_component()->escapeColumnName($name);
            $formattedDate = $listDao->convert_sql_date($value);

            $listDao->add_additional_having_conditions("{$fieldName} = {$formattedDate}");
            return true;
        }

        return false;
    }
}
