<?php

namespace idoit\Module\Cmdb\Model\Entry;

use idoit\Module\Cmdb\Interfaces\EntryInterface;

abstract class AbstractCollection
{
    /**
     * @var EntryInterface[]
     */
    public $entries = [];

    /**
     * @return EntryInterface[]
     */
    public function getEntries(): array
    {
        return $this->entries;
    }

    /**
     * @param $id
     *
     * @return EntryInterface|null
     */
    public function getEntry($id): ?EntryInterface
    {
        return $this->entries[$id] ?? null;
    }

    /**
     * @param $id
     *
     * @return bool
     */
    public function hasEntry($id): bool
    {
        return isset($this->entries[$id]);
    }

    /**
     * @param int $id
     *
     * @return void
     */
    public function unsetEntry($id): void
    {
        unset($this->entries[$id]);
    }
}
