[{isys_group name="tom.popup.custom-fields"}]
<div id="custom-fields-attribute-configuration-popup">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__SYSTEM__CUSTOM_CATEGORIES__PROPERTY"}] "[{$propertyTitle|escape:"html"}]"</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img alt="close" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content">
        <table class="contentTable">
            <tr>
                <td class="key vat">[{isys type="f_label" name="field_type" ident="LC__SYSTEM__CUSTOM_CATEGORIES__FIELD_TYPE"}]</td>
                <td class="value">[{isys name="field_type" type="f_dialog"}]</td>
            </tr>
            <tr class="notice hide">
                <td></td>
                <td>
                    <div class="box-blue p5 mr20 ml20">
                        <img src="[{$dir_images}]icons/silk/information.png" class="vam mr5">
                        <span class="van"><!-- Will be filled by JS --></span>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="key vat">[{isys type="f_label" name="field_title" ident="LC__SYSTEM__CUSTOM_CATEGORIES__FIELD_TITLE"}]</td>
                <td class="value">
                    <div data-type="single-line">
                        [{isys name="field_title" type="f_text" p_bNoTranslation="1"}]
                    </div>
                    <div data-type="multi-line" class="ml20 mr20">
                        [{isys name="field_title_multiline" type="f_textarea"}]
                        <div id="field_title_multiline_ace"><!-- Will be filled by JS --></div>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="key vat">[{isys type="lang" ident="LC__SYSTEM__CUSTOM_CATEGORIES__FIELD_ADDITIONAL"}]</td>
                <td class="value">
                    [{isys name="field_identifier" type="f_text"}]
                    [{isys name="field_dialog_default" type="f_dialog"}]
                    [{isys name="field_relation" type="f_dialog"}]
                </td>
            </tr>
            <tr class="dependency-field hide">
                <td class="key vat">
                    <img src="[{$dir_images}]icons/silk/information.png" class="mr5 vam mouse-help" title="[{isys type="lang" ident="LC__SYSTEM__CUSTOM_CATEGORIES__DEPENDENCY_INFO"|escape:"html"}]" />
                    [{isys type="f_label" name="field_dialog_dependency" ident="LC__SYSTEM__CUSTOM_CATEGORIES__DEPENDENCY"}]
                </td>
                <td class="value">[{isys name="field_dialog_dependency" type="f_dialog"}]</td>
            </tr>
            <tr class="dependency-field hide">
                <td class="key vat">[{isys type="f_label" name="field_dialog_linked_to" ident="LC__SYSTEM__CUSTOM_CATEGORIES__LINKED_TO"}]</td>
                <td class="value">[{isys name="field_dialog_linked_to" type="f_dialog"}]</td>
            </tr>
            <tr>
                <td class="key vat">[{isys type="f_label" name="field_visibility" ident="LC__SYSTEM__CUSTOM_CATEGORIES__FIELD_HANDLING"}]</td>
                <td class="value">[{isys name="field_visibility" type="f_dialog"}]</td>
            </tr>
            [{if $isMultivalueCategory}]
            <tr>
                <td class="key vat">[{isys type="lang" ident="LC__SYSTEM__CUSTOM_CATEGORIES__SHOW_IN_LIST"}]</td>
                <td class="value"><input type="checkbox" name="field_show_in_list" value="1" [{if $showInLine}]checked="checked"[{/if}] /></td>
            </tr>
            [{/if}]
        </table>
    </div>

    <div class="popup-footer-ng">
        <button type="button" class="btn mr5 save-configuration">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span>
        </button>

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
        </button>

        <button type="button" class="btn ml-auto delete-configuration">
            <img src="[{$dir_images}]axialis/basic/button-remove.svg" /><span>[{isys type="lang" ident="LC__SYSTEM__CUSTOM_CATEGORIES__FIELD_REMOVE"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        const $popup = $('custom-fields-attribute-configuration-popup');

        idoit.Require
            .addModule('custom-fields.attribute-configuration-popup', '[{isys_module_custom_fields::getWwwPath()}]assets/js/attribute-configuration-popup.js')
            .requireQueue(['custom-fields.attribute-configuration-popup', 'ace', 'aceLanguageTools'], function () {
                window.ace.require('ace/ext/language_tools');

                const editor = window.ace.edit('field_title_multiline_ace', {
                    theme: 'ace/theme/clouds',
                    mode: 'ace/mode/javascript',
                    minLines: 10,
                    maxLines: 30,
                    enableBasicAutocompletion: true,
                    enableSnippets: false,
                    enableLiveAutocompletion: true
                });

                const $multilineTitle = $('field_title_multiline');

                editor.session.setValue($multilineTitle.getValue());

                editor.session.on("change", function (e) {
                    $multilineTitle.setValue(editor.session.getValue());
                });

                const configPopup = new window.AttributeConfigurationPopup($popup, {
                    dialogYesNoDefaults: JSON.parse('[{$dialogYesNoDefaults|json_encode|escape:"javascript"}]'),
                    calendarDefaults: JSON.parse('[{$calendarDefaults|json_encode|escape:"javascript"}]'),
                    singleLineFields: JSON.parse('[{$singleLineFields|json_encode|escape:"javascript"}]'),
                    aceInstance: editor
                });

                $popup.on('click', '.popup-closer', function () {
                    popup_close();
                });

                $popup.on('click', '.save-configuration', function () {
                    const configuration = configPopup.getConfiguration();
                    configuration.key = '[{$key}]';

                    $('area').fire('field:update', configuration);
                    popup_close();
                });

                $popup.on('click', '.delete-configuration', function () {
                    $('area').fire('field:remove', { key: '[{$key}]' });
                    popup_close();
                });
            });
    })();
</script>

<style>
    .ace_editor {
        border: 1px solid #787979;
    }

    #custom-fields-attribute-configuration-popup table tr {
        height: 30px;
    }

    #custom-fields-attribute-configuration-popup table td:first-child {
        width: 120px;
        text-align: right;
    }

    #custom-fields-attribute-configuration-popup input[type="checkbox"] {
        margin-left: 20px;
    }
</style>
[{/isys_group}]
