<?php

/**
 * i-doit PRO
 *
 * Class autoloader.
 *
 * @package     Modules
 * @subpackage  Pro
 * @author      Dennis Stücken <dstuecken@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_pro_autoload extends isys_module_manager_autoload
{
    /**
     * @param string $className
     *
     * @return bool
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/pro/';
        $classMap = [
            'isys_ajax_handler_ip_addresses'                         => 'ajax/handler/isys_ajax_handler_ip_addresses.class.php',
            'isys_ajax_handler_visualization'                        => 'ajax/handler/isys_ajax_handler_visualization.class.php',
            'isys_cmdb_dao_category_g_cluster_shared_storage'        => 'cmdb/dao/global/isys_cmdb_dao_category_g_cluster_shared_storage.class.php',
            'isys_cmdb_dao_category_g_cluster_shared_virtual_switch' => 'cmdb/dao/global/isys_cmdb_dao_category_g_cluster_shared_virtual_switch.class.php',
            'isys_cmdb_dao_category_g_cluster_vitality'              => 'cmdb/dao/global/isys_cmdb_dao_category_g_cluster_vitality.class.php',
            'isys_cmdb_dao_category_g_images'                        => 'cmdb/dao/global/isys_cmdb_dao_category_g_images.class.php',
            'isys_cmdb_dao_category_g_network_port_overview'         => 'cmdb/dao/global/isys_cmdb_dao_category_g_network_port_overview.class.php',
            'isys_cmdb_dao_category_g_object_vitality'               => 'cmdb/dao/global/isys_cmdb_dao_category_g_object_vitality.class.php',
            'isys_cmdb_dao_category_g_planning'                      => 'cmdb/dao/global/isys_cmdb_dao_category_g_planning.class.php',
            'isys_cmdb_dao_category_g_rack_view'                     => 'cmdb/dao/global/isys_cmdb_dao_category_g_rack_view.class.php',
            'isys_cmdb_dao_category_g_stack_port_overview'           => 'cmdb/dao/global/isys_cmdb_dao_category_g_stack_port_overview.class.php',
            'isys_cmdb_dao_category_g_virtual_auth'                  => 'cmdb/dao/global/isys_cmdb_dao_category_g_virtual_auth.class.php',
            'isys_cmdb_dao_category_g_virtual_supernet'              => 'cmdb/dao/global/isys_cmdb_dao_category_g_virtual_supernet.class.php',
            'isys_cmdb_dao_category_s_chassis_view'                  => 'cmdb/dao/specific/isys_cmdb_dao_category_s_chassis_view.class.php',
            'isys_cmdb_dao_category_s_enclosure'                     => 'cmdb/dao/specific/isys_cmdb_dao_category_s_enclosure.class.php',
            'isys_cmdb_dao_category_s_group_type'                    => 'cmdb/dao/specific/isys_cmdb_dao_category_s_group_type.class.php',
            'isys_cmdb_dao_category_s_pdu_overview'                  => 'cmdb/dao/specific/isys_cmdb_dao_category_s_pdu_overview.class.php',
            'isys_cmdb_ui_category_g_cluster_shared_storage'         => 'cmdb/ui/global/isys_cmdb_ui_category_g_cluster_shared_storage.class.php',
            'isys_cmdb_ui_category_g_cluster_shared_virtual_switch'  => 'cmdb/ui/global/isys_cmdb_ui_category_g_cluster_shared_virtual_switch.class.php',
            'isys_cmdb_ui_category_g_cluster_vitality'               => 'cmdb/ui/global/isys_cmdb_ui_category_g_cluster_vitality.class.php',
            'isys_cmdb_ui_category_g_images'                         => 'cmdb/ui/global/isys_cmdb_ui_category_g_images.class.php',
            'isys_cmdb_ui_category_g_network_port_overview'          => 'cmdb/ui/global/isys_cmdb_ui_category_g_network_port_overview.class.php',
            'isys_cmdb_ui_category_g_object_vitality'                => 'cmdb/ui/global/isys_cmdb_ui_category_g_object_vitality.class.php',
            'isys_cmdb_ui_category_g_planning'                       => 'cmdb/ui/global/isys_cmdb_ui_category_g_planning.class.php',
            'isys_cmdb_ui_category_g_rack_view'                      => 'cmdb/ui/global/isys_cmdb_ui_category_g_rack_view.class.php',
            'isys_cmdb_ui_category_g_stack_port_overview'            => 'cmdb/ui/global/isys_cmdb_ui_category_g_stack_port_overview.class.php',
            'isys_cmdb_ui_category_g_virtual_auth'                   => 'cmdb/ui/global/isys_cmdb_ui_category_g_virtual_auth.class.php',
            'isys_cmdb_ui_category_g_virtual_supernet'               => 'cmdb/ui/global/isys_cmdb_ui_category_g_virtual_supernet.class.php',
            'isys_cmdb_ui_category_s_chassis_view'                   => 'cmdb/ui/specific/isys_cmdb_ui_category_s_chassis_view.class.php',
            'isys_cmdb_ui_category_s_enclosure'                      => 'cmdb/ui/specific/isys_cmdb_ui_category_s_enclosure.class.php',
            'isys_cmdb_ui_category_s_group_type'                     => 'cmdb/ui/specific/isys_cmdb_ui_category_s_group_type.class.php',
            'isys_cmdb_ui_category_s_net_ip_addresses'               => 'cmdb/ui/specific/isys_cmdb_ui_category_s_net_ip_addresses.class.php',
            'isys_cmdb_ui_category_s_pdu_overview'                   => 'cmdb/ui/specific/isys_cmdb_ui_category_s_pdu_overview.class.php',
            'isys_cmdb_view_explorer'                                => 'cmdb/view/isys_cmdb_view_explorer.class.php',
            'isys_dashboard_widgets_cmdbexplorer'                    => 'dashboard/widgets/cmdbexplorer/isys_dashboard_widgets_cmdbexplorer.class.php',
            'isys_dashboard_widgets_cmdb_statuslivecycle'            => 'dashboard/widgets/cmdb/statuslivecycle/isys_dashboard_widgets_cmdb_statuslivecycle.class.php',
            'isys_dashboard_widgets_eval'                            => 'dashboard/widgets/eval/isys_dashboard_widgets_eval.class.php',
            'isys_dashboard_widgets_itserviceconsistency'            => 'dashboard/widgets/itserviceconsistency/isys_dashboard_widgets_itserviceconsistency.class.php',
            'isys_dashboard_widgets_objinfo'                         => 'dashboard/widgets/objinfo/isys_dashboard_widgets_objinfo.class.php',
            'isys_dashboard_widgets_stats'                           => 'dashboard/widgets/stats/isys_dashboard_widgets_stats.class.php',
            'isys_dashboard_widgets_statstable'                      => 'dashboard/widgets/statstable/isys_dashboard_widgets_statstable.class.php',
            'isys_popup_connection'                                  => 'popup/isys_popup_connection.class.php',
            'isys_popup_visualization_export'                        => 'visualization/popup/isys_popup_visualization_export.class.php',
            'isys_popup_visualization_itservice_selection'           => 'visualization/popup/isys_popup_visualization_itservice_selection.class.php',
            'isys_popup_visualization_profile'                       => 'visualization/popup/isys_popup_visualization_profile.class.php',
            'isys_popup_custom_translation_import'                   => 'src/SettingPage/CustomTranslation/isys_popup_custom_translation_import.class.php',
            'isys_popup_custom_translation_new'                      => 'src/SettingPage/CustomTranslation/isys_popup_custom_translation_new.class.php',
            'isys_visualization'                                     => 'visualization/isys_visualization.class.php',
            'isys_visualization_export'                              => 'visualization/export/isys_visualization_export.class.php',
            'isys_visualization_export_graphml'                      => 'visualization/export/isys_visualization_export_graphml.class.php',
            'isys_visualization_graph'                               => 'visualization/graph/isys_visualization_graph.class.php',
            'isys_visualization_graph_model'                         => 'visualization/graph/isys_visualization_graph_model.class.php',
            'isys_visualization_graph_visitor'                       => 'visualization/visitor/isys_visualization_graph_visitor.class.php',
            'isys_visualization_model'                               => 'visualization/isys_visualization_model.class.php',
            'isys_visualization_profile_model'                       => 'visualization/profile/isys_visualization_profile_model.class.php',
            'isys_visualization_tree'                                => 'visualization/tree/isys_visualization_tree.class.php',
            'isys_visualization_tree_model'                          => 'visualization/tree/isys_visualization_tree_model.class.php',
            'isys_visualization_tree_visitor'                        => 'visualization/visitor/isys_visualization_tree_visitor.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()
                ->ns('autoload')
                ->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
