<?php
/**
 * i-doit
 *
 * my-doit Area
 *
 * @package    i-doit
 * @subpackage General
 * @author     Andre Woesten <awoesten@i-doit.org> - 2006-05-06
 * @version    1.0
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

$l_db = isys_application::instance()->database;

$l_dao = new isys_component_dao($l_db);
$l_settingID = isys_component_dao_user::instance($l_db)
    ->get_user_setting_id();

if ($l_settingID != null) {
    if (isset($_POST["mydoitAction"])) {
        try {
            $l_action = $_POST["mydoitAction"];
            if ($l_action == "add") {

                // Add an entry.
                $l_modman = isys_module_manager::instance();
                $l_actmod = $l_modman->get_active_module();

                // ID-3786: If q is given and not empty there is a search request
                if (isset($_GET['q']) && !empty($_GET['q']) && defined('C__MODULE__SEARCH')) {
                    $l_actmod = C__MODULE__SEARCH;
                }

                if ($l_actmod) {
                    // Return active module register entry.
                    $l_modreg = $l_modman->get_by_id($l_actmod);

                    if ($l_modreg->is_initialized()) {
                        // The module data includes the module title.
                        $l_moddata = $l_modreg->get_data();

                        // Asking module for its breadcrumb navigation.
                        $l_modobj = $l_modreg->get_object();

                        $language = isys_application::instance()->container->get('language');

                        if (method_exists($l_modobj, "mydoit_get")) {
                            $l_out = null;
                            $l_link = null;

                            if ($l_modobj->mydoit_get($l_out, $l_link)) {
                                // Finish link.
                                $l_link = urlencode(isys_glob_build_url($l_link));

                                // Build text.
                                $l_out = '[' . $language->get($l_moddata['isys_module__title']) . '] ' . implode(' &raquo; ', $l_out);

                                // Good - insert into database now.
                                $insertQuery = 'INSERT INTO isys_user_mydoit 
                                    SET isys_user_mydoit__isys_user_setting__id = ' . $l_dao->convert_sql_id($l_settingID) . ',
                                    isys_user_mydoit__title = ' . $l_dao->convert_sql_text($l_out) . ',
                                    isys_user_mydoit__link = ' . $l_dao->convert_sql_text($l_link) . ',
                                    isys_user_mydoit__date_added = NOW();';

                                if ($l_dao->update($insertQuery) && $l_dao->apply_update()) {
                                    // Good. now show mydoIT-Area automatically.
                                    isys_application::instance()->template->assign("mydoitShow", 1);
                                }
                            } else {
                                throw new Exception($language->get('LC__MYDOIT__ERROR_NO_SUPPORT'));
                            }
                        }
                    }
                }
            } elseif ($l_action == "delete") {
                // Delete selected entries.
                if (isset($_POST["mydoitSelection"]) && is_array($_POST["mydoitSelection"])) {
                    foreach ($_POST["mydoitSelection"] as $l_selID => $l_selStatus) {
                        $deleteSql = 'DELETE FROM isys_user_mydoit 
                            WHERE isys_user_mydoit__id = ' . $l_dao->convert_sql_id($l_selID) . ' 
                            AND isys_user_mydoit__isys_user_setting__id = ' . $l_dao->convert_sql_id($l_settingID) . ';';

                        if ($l_dao->update($deleteSql) && $l_dao->apply_update()) {
                            isys_application::instance()->template->assign("mydoitShow", 1);
                        }
                    }
                }
            }
        } catch (Exception $e) {
            isys_notify::error($e->getMessage());
        }
    }

    /* Query database for bookmarks */
    $l_q = 'SELECT * FROM isys_user_mydoit WHERE isys_user_mydoit__isys_user_setting__id = ' . $l_dao->convert_sql_id($l_settingID) . ';';
    $l_res = $l_dao->retrieve($l_q);
    $l_bookmarks = [];
    $l_nbookmarks = $l_res->num_rows();
    if ($l_res && ($l_nbookmarks > 0)) {
        /* Build up SMARTY Array with bookmarks */
        while ($l_row = $l_res->get_row()) {
            $l_bookmarks[$l_row["isys_user_mydoit__id"]] = [
                "text" => $l_row["isys_user_mydoit__title"],
                "link" => urldecode($l_row["isys_user_mydoit__link"])
            ];
        }
    }

    isys_application::instance()->template->assign("mydoit", [
        "bookmarkList"  => $l_bookmarks,
        "bookmarkCount" => $l_nbookmarks
    ]);
}

/* my-tasks area */
if (class_exists('isys_workflow_dao_action')) {
    require_once("my-tasks.inc.php");
}

require_once("my-search.inc.php");

/**
 * CMDB Status
 */
if (isys_tenantsettings::get('system.mydoit.show_filter', 1)) {
    include_once("cmdb-status.inc.php");
}
