<?php

global $g_comp_database, $g_comp_database_system;

// Set migrationId
$migrationIdentifier = 'migrate_text_descriptions';

// Check whether migration was executed before
if ($this->is_migration_done($migrationIdentifier)) {
    $g_migration_log[] = '<span class="bold">Description migration has already been processed</span>';
} else {
    $g_migration_log[] = '<span class="bold">Migrate Description fields from "text" to "longtext"...</span>';

    $dao = new \isys_cmdb_dao($g_comp_database);

    $missingTables = 0;
    $missingTableFields = 0;
    $migratedTables = 0;
    $notMigratedTables = 0;
    $errors = 0;

    // This list comes from our setup-dump it should represent the base-set of description fields.
    $descriptionFields = [
        'isys_ac_air_quantity_unit__description',
        'isys_ac_refrigerating_capacity_unit__description',
        'isys_ac_type__description',
        'isys_access_type__description',
        'isys_account__description',
        'isys_agent__description',
        'isys_application_manufacturer__description',
        'isys_backup_cycle__description',
        'isys_backup_type__description',
        'isys_business_unit__description',
        'isys_cable_colour__description',
        'isys_cable_occupancy__description',
        'isys_cable_type__description',
        'isys_calendar__description',
        'isys_catd_drive_type__description', // Was in(10) for some reason?
        'isys_catg_access_list__description',
        'isys_catg_accounting_cost_unit__description',
        'isys_catg_accounting_list__description',
        'isys_catg_accounting_procurement__description',
        'isys_catg_address_list__description',
        'isys_catg_aircraft_list__description',
        'isys_catg_application_list__description',
        'isys_catg_application_priority__description',
        'isys_catg_application_type__description',
        'isys_catg_assigned_cards_list__description',
        'isys_catg_assigned_subscriptions_list__description',
        'isys_catg_assigned_users_list__description',
        'isys_catg_audit_list__description',
        'isys_catg_audit_type__description',
        'isys_catg_backup_list__description',
        'isys_catg_cable_list__description',
        'isys_catg_cards_list__description',
        'isys_catg_certificate_list__description',
        'isys_catg_cloud_subscriptions_list__description',
        'isys_catg_cluster_adm_service_list__description',
        'isys_catg_cluster_list__description',
        'isys_catg_cluster_members_list__description',
        'isys_catg_cluster_service_list__description',
        'isys_catg_computing_resources_list__description',
        'isys_catg_connection_endpoint_list__description',
        'isys_catg_connector_list__description',
        'isys_catg_contact_list__description',
        'isys_catg_contract_assignment_list__description',
        'isys_catg_controller_list__description',
        'isys_catg_cpu_list__description',
        'isys_catg_cpu_manufacturer__description',
        'isys_catg_cpu_type__description',
        'isys_catg_custom_fields_list__description',
        'isys_catg_database_assignment_list__description',
        'isys_catg_database_list__description',
        'isys_catg_database_sa_list__description',
        'isys_catg_database_table_list__description',
        'isys_catg_drive_list__description',
        'isys_catg_emergency_plan_list__description',
        'isys_catg_fc_port_list__description',
        'isys_catg_fiber_lead_list__description',
        'isys_catg_file_list__description',
        'isys_catg_formfactor_list__description',
        'isys_catg_formfactor_type__description',
        'isys_catg_global_category__description',
        'isys_catg_global_list__description',
        'isys_catg_graphic_list__description',
        'isys_catg_guest_systems_list__description',
        'isys_catg_hba_list__description',
        'isys_catg_identifier_list__description',
        'isys_catg_identifier_type__description',
        'isys_catg_image_list__description',
        'isys_catg_invoice_list__description',
        'isys_catg_ip_list__description',
        'isys_catg_its_components_list__description',
        'isys_catg_its_type_list__description',
        'isys_catg_jdisc_ca_list__description',
        'isys_catg_jdisc_device_information_list__description',
        'isys_catg_last_login_user_list__description',
        'isys_catg_ldap_dn_list__description',
        'isys_catg_ldevclient_list__description',
        'isys_catg_ldevserver_list__description',
        'isys_catg_location_list__description',
        'isys_catg_log_port_list__description',
        'isys_catg_logb_list__description',
        'isys_catg_logical_unit_list__description',
        'isys_catg_mail_addresses_list__description',
        'isys_catg_manual_list__description',
        'isys_catg_memory_list__description',
        'isys_catg_model_list__description',
        'isys_catg_monitoring_list__description',
        'isys_catg_net_connector_list__description',
        'isys_catg_net_listener_list__description',
        'isys_catg_net_type_list__description',
        'isys_catg_net_zone_options_list__description',
        'isys_catg_netp_list__description',
        'isys_catg_overview_list__description',
        'isys_catg_password_list__description',
        'isys_catg_pc_list__description',
        'isys_catg_planning_list__description',
        'isys_catg_port_list__description',
        'isys_catg_power_supplier_list__description',
        'isys_catg_qinq_list__description',
        'isys_catg_raid_list__description',
        'isys_catg_relation_list__description',
        'isys_catg_rm_controller_list__description',
        'isys_catg_sanpool_list__description',
        'isys_catg_service_list__description',
        'isys_catg_share_access_list__description',
        'isys_catg_shares_list__description',
        'isys_catg_sim_card_list__description',
        'isys_catg_sim_list__description',
        'isys_catg_sla_list__description',
        'isys_catg_smartcard_certificate_list__description',
        'isys_catg_snmp_list__description',
        'isys_catg_soa_components_list__description',
        'isys_catg_soa_stacks_list__description',
        'isys_catg_sound_list__description',
        'isys_catg_stack_member_list__description',
        'isys_catg_stacking_list__description',
        'isys_catg_stor_list__description',
        'isys_catg_support_entitlement_list__description',
        'isys_catg_telephone_fax_list__description',
        'isys_catg_tsi_service_list__description',
        'isys_catg_ui_list__description',
        'isys_catg_vehicle_list__description',
        'isys_catg_version_list__description',
        'isys_catg_virtual_device_list__description',
        'isys_catg_virtual_host_list__description',
        'isys_catg_virtual_list__description',
        'isys_catg_virtual_machine_list__description',
        'isys_catg_virtual_switch_list__description',
        // 'isys_catg_voip_phone_line_list__description2', // Skip, it's a normal input field
        'isys_catg_voip_phone_line_list__description',
        'isys_catg_voip_phone_list__description',
        // 'isys_catg_voip_phone_list__description2', // Skip, it's a normal input field
        'isys_catg_vrrp_list__description',
        'isys_catg_vrrp_member_list__description',
        'isys_catg_wan_list__description',
        'isys_cats_ac_list__description',
        'isys_cats_access_point_list__description',
        'isys_cats_app_variant_list__description',
        'isys_cats_application_list__description',
        'isys_cats_building_list__description',
        'isys_cats_chassis_list__description',
        'isys_cats_chassis_slot_list__description',
        'isys_cats_chassis_view_list__description',
        'isys_cats_client_list__description',
        'isys_cats_contract_list__description',
        'isys_cats_cp_contract_list__description',
        'isys_cats_database_access_list__description',
        'isys_cats_database_gateway_list__description',
        'isys_cats_database_instance_list__description',
        'isys_cats_database_links_list__description',
        'isys_cats_database_objects_list__description',
        'isys_cats_database_schema_list__description',
        'isys_cats_dbms_list__description',
        'isys_cats_emergency_plan_list__description',
        'isys_cats_enclosure_list__description',
        'isys_cats_eps_list__description',
        'isys_cats_eps_type__description',
        'isys_cats_file_list__description',
        'isys_cats_group_list__description',
        'isys_cats_group_type_list__description',
        'isys_cats_krypto_card_list__description',
        'isys_cats_layer2_net_list__description',
        'isys_cats_lic_list__description',
        'isys_cats_mobile_phone_list__description',
        'isys_cats_monitor_list__description',
        'isys_cats_net_dhcp_list__description',
        'isys_cats_net_list__description',
        'isys_cats_net_zone_list__description',
        'isys_cats_organization_list__description',
        'isys_cats_pdu_branch_list__description',
        'isys_cats_pdu_list__description',
        'isys_cats_person_group_list__description',
        'isys_cats_person_list__description',
        'isys_cats_prt_emulation__description',
        'isys_cats_prt_list__description',
        'isys_cats_prt_paper__description',
        'isys_cats_prt_type__description',
        'isys_cats_relpool_list__description',
        'isys_cats_replication_list__description',
        'isys_cats_replication_partner_list__description',
        'isys_cats_room_list__description',
        'isys_cats_router_list__description',
        'isys_cats_san_list__description',
        'isys_cats_san_zoning_list__description',
        'isys_cats_service_list__description',
        'isys_cats_switch_fc_list__description',
        'isys_cats_switch_net_list__description',
        'isys_cats_tapelib_list__description',
        'isys_cats_ups_list__description',
        'isys_cats_virtual__description',
        'isys_cats_virtual_list__description',
        'isys_cats_wan_list__description',
        'isys_cats_ws_net_type_list__description',
        'isys_certificate_type__description',
        'isys_chassis_connector_type__description',
        'isys_chassis_role__description',
        'isys_client_type__description',
        'isys_cluster_type__description',
        'isys_cmdb_status__description',
        'isys_connection_type__description',
        'isys_contact__description',
        'isys_contact_tag__description',
        'isys_contract_end_type__description',
        'isys_contract_notice_period_type__description',
        'isys_contract_payment_period__description',
        'isys_contract_reaction_rate__description',
        'isys_contract_status__description',
        'isys_contract_type__description',
        'isys_controller_manufacturer__description',
        'isys_controller_model__description',
        'isys_controller_type__description',
        'isys_cp_contract_type__description', // Was in(10) for some reason?
        'isys_currency__description',
        'isys_database_instance_type__description',
        'isys_database_objects__description',
        'isys_database_schema__description',
        'isys_dbms__description',
        'isys_dependency__description',
        'isys_depth_unit__description',
        'isys_dialog_plus_custom__description',
        'isys_fc_port_medium__description',
        'isys_fc_port_type__description',
        'isys_fiber_category__description',
        'isys_fiber_wave_length__description',
        'isys_file_category__description',
        'isys_file_physical__description',
        'isys_file_version__description',
        'isys_filesystem_type__description',
        'isys_frequency_unit__description',
        'isys_graphic_manufacturer__description',
        'isys_guarantee_period_unit__description',
        'isys_hba_type__description',
        'isys_iface_manufacturer__description',
        'isys_iface_model__description',
        'isys_import_type__description',
        'isys_installation_type__description',
        'isys_interface__description',
        'isys_interval__description',
        'isys_ip_assignment__description',
        'isys_ipv6_assignment__description',
        'isys_ipv6_scope__description',
        'isys_its_type__description',
        'isys_jdisc_ca_type__description',
        'isys_jdisc_device_type__description',
        'isys_jdisc_profile__description',
        'isys_jdisc_status_list__description',
        'isys_layer2_iphelper_type__description',
        'isys_layer2_net_subtype__description',
        'isys_layer2_net_type__description',
        'isys_ldev_multipath__description',
        'isys_logbook__description',
        'isys_logbook_event__description',
        'isys_logbook_event_class__description',
        'isys_logbook_lc_parameter__description',
        'isys_logbook_level__description',
        'isys_logbook_reason__description',
        'isys_logbook_source__description',
        'isys_maintenance_contract_type__description',
        'isys_maintenance_reaction_rate__description',
        'isys_maintenance_status__description',
        'isys_memory_manufacturer__description',
        'isys_memory_title__description',
        'isys_memory_type__description',
        'isys_memory_unit__description',
        'isys_model_manufacturer__description',
        'isys_model_title__description',
        'isys_monitor_resolution__description',
        'isys_monitor_type__description',
        'isys_monitor_unit__description',
        'isys_net_dhcp_type__description',
        'isys_net_dhcpv6_type__description',
        'isys_net_dns_domain__description',
        'isys_net_dns_server__description',
        'isys_net_protocol__description',
        'isys_net_protocol_layer_5__description',
        'isys_net_type__description',
        'isys_net_type_title__description',
        'isys_netp_ifacel__description',
        'isys_netp_ifacel_standard__description',
        'isys_netv_ifacel__description',
        'isys_network_provider__description',
        'isys_netx_ifacel_type__description',
        'isys_notification__description',
        'isys_notification_type__description',
        'isys_obj__description',
        'isys_obj_type__description',
        'isys_obj_type_group__description', // Was in(10) for some reason?
        'isys_organisation_intern_iop__description',
        'isys_p_mode__description',
        'isys_pc_manufacturer__description',
        'isys_pc_model__description',
        'isys_pc_title__description',
        'isys_pobj_type__description',
        'isys_port_duplex__description',
        'isys_port_mode__description',
        'isys_port_negotiation__description',
        'isys_port_speed__description',
        'isys_port_standard__description',
        'isys_port_type__description',
        'isys_pos_gps__description',
        'isys_power_connection_type__description',
        'isys_power_fuse_ampere__description',
        'isys_power_fuse_type__description',
        'isys_purpose__description',
        'isys_raid_type__description',
        'isys_replication_mechanism__description',
        'isys_replication_type__description',
        'isys_report__description',
        'isys_report_category__description',
        'isys_right__description',
        'isys_right_2_isys_role__description',
        'isys_role__description',
        'isys_room_type__description',
        'isys_routing_protocol__description',
        'isys_san_capacity_unit__description',
        'isys_search__description',
        'isys_service_alias__description',
        'isys_service_category__description',
        'isys_service_manufacturer__description',
        'isys_service_type__description',
        'isys_site__description',
        'isys_sla_service_level__description',
        'isys_snmp_community__description',
        'isys_sound_manufacturer__description',
        'isys_stor_con_type__description',
        'isys_stor_lto_type__description',
        'isys_stor_manufacturer__description',
        'isys_stor_model__description',
        'isys_stor_raid_level__description',
        'isys_stor_type__description',
        'isys_stor_unit__description',
        'isys_switch_role__description',
        'isys_switch_spanning_tree__description',
        'isys_tag__description',
        'isys_tapelib_type__description',
        'isys_telephone_fax_type__description',
        'isys_telephone_rate__description',
        'isys_temp_unit__description',
        'isys_tierclass__description',
        'isys_tree_group__description',
        'isys_tts_type__description',
        'isys_ui_con_type__description',
        'isys_ui_plugtype__description',
        'isys_unit__description',
        'isys_unit_of_time__description',
        'isys_ups_battery_type__description',
        'isys_ups_type__description',
        'isys_user_mydoit__description',
        'isys_user_session__description',
        'isys_virtual_network_type__description',
        'isys_virtual_storage_type__description',
        'isys_vlan_management_protocol__description',
        'isys_vm_type__description',
        'isys_voip_phone_button_template__description',
        'isys_voip_phone_softkey_template__description',
        'isys_volume_unit__description',
        'isys_vrrp_type__description',
        'isys_wan_capacity_unit__description',
        'isys_wan_role__description',
        'isys_wan_type__description',
        'isys_wato_folder__description',
        'isys_weight_unit__description',
        'isys_weighting__description',
        'isys_widgets__description',
        'isys_wlan_auth__description',
        'isys_wlan_channel__description',
        'isys_wlan_encryption__description',
        'isys_wlan_function__description',
        'isys_wlan_standard__description',
        'isysgui_catg__description',
        'isysgui_cats__description',
    ];

    foreach ($descriptionFields as $descriptionField) {
        [$table] = explode('__', $descriptionField);

        if (!$dao->table_exists($table)) {
            $missingTables++;
            continue;
        }

        $field = $dao
            ->getTableFieldInfo($table, $descriptionField)
            ->get_row();

        if (empty($field)) {
            $missingTableFields++;
            continue;
        }

        if (strpos($field['Type'], 'longtext') === 0) {
            $notMigratedTables++;
            continue;
        }

        try {
            $updateQuery = "ALTER TABLE {$table} MODIFY {$descriptionField} LONGTEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL;";

            $dao->update($updateQuery) && $dao->apply_update();

            $g_migration_log[] = '<span class="indent">Change field "' . $descriptionField . '" with type "' . $field['Type'] . '" to "longtext".</span>';
            $migratedTables++;
        } catch (Exception $e) {
            $g_migration_log[] = '<span class="indent text-red">Error: ' . $e->getMessage() . '</span>';
            $errors++;
        }
    }

    if ($missingTables > 0) {
        $g_migration_log[] = '<span class="bold">' . $missingTables . ' tables did not exist in your database (this is not a problem).</span>';
    }

    if ($missingTableFields > 0) {
        $g_migration_log[] = '<span class="bold">' . $missingTableFields . ' description fields did not exist in their table.</span>';
    }

    if ($migratedTables > 0) {
        $g_migration_log[] = '<span class="bold text-green">Migrated ' . $migratedTables . ' tables.</span>';
    }

    $g_migration_log[] = '<span class="bold text-green">' . $notMigratedTables . ' tables did not need to be updated.</span>';

    if ($errors > 0) {
        $g_migration_log[] = '<span class="indent bold text-red">' . $errors . ' tables could not be updated.</span>';
    }

    $g_migration_log[] = '<span class="bold">Migration finished!</span>';

    $this->migration_done($migrationIdentifier);
}
