<?php
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Module\Console\Steps\Dao;

use idoit\Module\Console\Steps\Message\ErrorLevel;
use idoit\Module\Console\Steps\Message\Messages;
use idoit\Module\Console\Steps\Message\StepMessage;
use idoit\Module\Console\Steps\Step;
use idoit\Module\Console\Steps\Undoable;
use idoit\Module\License\Event\Tenant\TenantActivatedEvent;
use idoit\Module\License\LicenseService;
use isys_component_dao_mandator;
use isys_component_database;

class TenantEnable implements Step, Undoable
{
    /**
     * @var isys_component_dao_mandator
     */
    private $dao;

    private $id;

    private $done;

    /**
     * @var LicenseService
     */
    private $licenseService;

    public function __construct(isys_component_database $database, $id, ?LicenseService $licenseService = null)
    {
        $this->dao = isys_component_dao_mandator::instance($database);
        $this->id = $id;
        $this->licenseService = $licenseService;
    }

    /**
     * Get name of the step
     *
     * @return string
     */
    public function getName()
    {
        return 'Enable Tenant ' . $this->id;
    }

    /**
     * Process the work
     *
     * @param Messages $messages
     *
     * @return mixed
     */
    public function process(Messages $messages)
    {
        $this->done = false;
        $mandator = $this->dao->get_mandator($this->id, false)
            ->get_row();
        if (empty($mandator)) {
            $messages->addMessage(new StepMessage($this, 'does not exist', ErrorLevel::ERROR));

            return true;
        }
        if (isset($mandator['isys_mandator__active']) && $mandator['isys_mandator__active']) {
            $messages->addMessage(new StepMessage($this, 'is already active', ErrorLevel::INFO));

            return true;
        }
        $result = $this->dao->activate_mandator($this->id);
        if ($result) {
            $this->done = true;
        }

        $messages->addMessage(new StepMessage($this, $result ? 'activated' : 'is not activated', $result ? ErrorLevel::INFO : ErrorLevel::ERROR));

        if ($this->licenseService) {
            $this->licenseService->getEventDispatcher()
                ->dispatch(new TenantActivatedEvent(), TenantActivatedEvent::NAME);
        }

        return $result;
    }

    /**
     * Undo the work
     *
     * @param Messages $messages
     *
     * @return mixed
     */
    public function undo(Messages $messages)
    {
        if ($this->done) {
            $result = $this->dao->deactivate_mandator($this->id);
            $messages->addMessage(new StepMessage($this, $result ? 'deactivated' : 'is not deactivated', $result ? ErrorLevel::INFO : ErrorLevel::ERROR));

            return $result;
        }

        return true;
    }
}
