<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type IntegrationRegistrationInput
 * The integration registration is required when other tools like CMDB solution register as a data importer.

Whenever there is at least one integration registered, JDisc Discovery calculates hash values for
all data categories (such as memory modules, processors etc.). A CMDB integration can then call a method to mark a device as
imported. When a device is marked as imported, it clones the hash values. That enables an easy comparison between the current device data
and the state when it was imported the last time. Devices with no change in their data do not need to be imported again. * @property null|string $applicationName = null The name for the integrating application (e.g. the CMDB product name)
 * @property null|string $id = null The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
 * @property null|string $instanceName = null The instance name (in case there are multiple instances for an integrated product
 * @property null|string $uniqueId = null The unique id. External tools should refer to the integration only by their unique id
 */
final class IntegrationRegistrationInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        return $value;
    }
}