<?php
/**
 * i-doit
 *
 * Static constant not registered by the dynamic constant manager.
 * Please empty this list every major release.
 *
 * @package     i-doit
 * @subpackage  General
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

$systemSettings = isys_application::instance()->container->get('settingsSystem');
$tenantSettings = isys_application::instance()->container->get('settingsTenant');
$userSettings = isys_application::instance()->container->get('settingsUser');
$session = isys_application::instance()->container->get('session');

// @see ID-934 -- global and specific categories
$replacementConstants = [
    'C__CMDB__SUBCAT__NETWORK_PORT'                      => 'C__CATG__NETWORK_PORT',
    'C__CMDB__SUBCAT__NETWORK_INTERFACE_P'               => 'C__CATG__NETWORK_INTERFACE',
    'C__CMDB__SUBCAT__NETWORK_INTERFACE_L'               => 'C__CATG__NETWORK_LOG_PORT',
    'C__CMDB__SUBCAT__STORAGE__DEVICE'                   => 'C__CATG__STORAGE_DEVICE',
    'C__CMDB__SUBCAT__NETWORK_PORT_OVERVIEW'             => 'C__CATG__NETWORK_PORT_OVERVIEW',
    'C__CMDB__SUBCAT__LICENCE_LIST'                      => 'C__CATS__LICENCE_LIST',
    'C__CMDB__SUBCAT__LICENCE_OVERVIEW'                  => 'C__CATS__LICENCE_OVERVIEW',
    'C__CMDB__SUBCAT__EMERGENCY_PLAN_LINKED_OBJECT_LIST' => 'C__CATS__EMERGENCY_PLAN_LINKED_OBJECTS',
    'C__CMDB__SUBCAT__EMERGENCY_PLAN'                    => 'C__CATS__EMERGENCY_PLAN_ATTRIBUTE',
    'C__CMDB__SUBCAT__WS_NET_TYPE'                       => 'C__CATS__WS_NET_TYPE',
    'C__CMDB__SUBCAT__WS_ASSIGNMENT'                     => 'C__CATS__WS_ASSIGNMENT',
    'C__CMDB__SUBCAT__FILE_OBJECTS'                      => 'C__CATS__FILE_OBJECTS',
    'C__CMDB__SUBCAT__FILE_VERSIONS'                     => 'C__CATS__FILE_VERSIONS',
    'C__CMDB__SUBCAT__FILE_ACTUAL'                       => 'C__CATS__FILE_ACTUAL',
];

foreach ($replacementConstants as $oldConstant => $newConstant) {
    if (!defined($oldConstant) && defined($newConstant)) {
        define($oldConstant, constant($newConstant));
    }
}

// @see ID-6912 This can happen if `nostalgia` gets included before `import`.
if (defined('C__IMPORT__DIRECTORY')) {
    $csvImportDirectory = C__IMPORT__DIRECTORY;
} else {
    $uploadDir = $tenantSettings->get('system.dir.import-uploads', BASE_DIR . '/imports/');
    $csvImportDirectory = $tenantSettings->get('system.dir.csv-uploads', rtrim($uploadDir, '/') . '/') . $session->get_mandator_id() . '/';
}

$constants = [
    // System constants from table 'isys_const_system' (in 'idoit_system').
    'C__CAT_LISTVIEW__OFF'                  => 0,
    'C__CAT_LISTVIEW__ON'                   => 1,
    'C__CHECK_PERMISSION__APPEND'           => 4,
    'C__CHECK_PERMISSION__DELETE'           => 2,
    'C__CHECK_PERMISSION__DUPLICATE'        => 3,
    'C__CHECK_PERMISSION__EDIT'             => 1,
    'C__CHECK_PERMISSION__RECYCLE'          => 5,
    'C__CMDB__CATD'                         => 3,
    'C__CMDB__CATEGORY__POBJ_FEMALE_SOCKET' => 1,
    'C__CMDB__CATEGORY__POBJ_MALE_PLUG'     => 0,
    'C__CMDB__CATG'                         => 1,
    'C__CMDB__CATS'                         => 2,
    'C__CMDB_TREEMODE__GCAT'                => 1,
    'C__CMDB_TREEMODE__OBJTYPE'             => 1,
    'C__CMDB_VIEWMODE__LOCATION'            => 0,
    'C__CMDB_VIEWMODE__OBJECT'              => 0,
    'C__F_POPUP__CONTACT'                   => 3,
    'C__F_POPUP__DATETIME'                  => 2,
    'C__F_POPUP__LOCATION'                  => 1,
    'C__F_POPUP__PICTURE'                   => 4,
    'C__LINK__POBJ_FEMALE_SOCKET'           => 1,
    'C__LINK__POBJ_MALE_PLUG'               => 1,
    'C__MAX_COUNT__GET_HISTORY'             => 5,
    'C__NAVBAR_BUTTON__BLANK'               => 11,
    'C__RECORD_PROPERTY__NOT_SHOW_IN_LIST'  => 16,

    // Old LDAP related constants, remove in i-doit 1.19
    'C__LDAP__DEBUG'                        => $systemSettings->get('ldap.debug', true),
    /*
     * Attaches LDAP users automatically to these group ids (comma-separated)
     *   - Only one group is also possible
     *   - Only group IDs will work, e.g. 15 for admin. Contacts->Groups for more
     */
    'C__LDAP__GROUP_IDS'                    => $tenantSettings->get('ldap.default-group', ''),

    // Remove old unused navbar buttons
    'C__NAVBAR_BUTTON__UP'                  => 8, // @todo  Remove in 1.21
    'C__NAVMODE__UP'                        => 8, // @todo  Remove in 1.21

    // Remove old unused 'month' constants.
    'C__MONTH__JANUARY'                     => 'january', // @todo  Remove in 1.21
    'C__MONTH__FEBRUARY'                    => 'february', // @todo  Remove in 1.21
    'C__MONTH__MARCH'                       => 'march', // @todo  Remove in 1.21
    'C__MONTH__APRIL'                       => 'april', // @todo  Remove in 1.21
    'C__MONTH__MAY'                         => 'may', // @todo  Remove in 1.21
    'C__MONTH__JUNE'                        => 'june', // @todo  Remove in 1.21
    'C__MONTH__JULY'                        => 'july', // @todo  Remove in 1.21
    'C__MONTH__AUGUST'                      => 'august', // @todo  Remove in 1.21
    'C__MONTH__SEPTEMBER'                   => 'september', // @todo  Remove in 1.21
    'C__MONTH__OCTOBER'                     => 'october', // @todo  Remove in 1.21
    'C__MONTH__NOVEMBER'                    => 'november', // @todo  Remove in 1.21
    'C__MONTH__DECEMBER'                    => 'december', // @todo  Remove in 1.21

    // Remove old unused 'view mode'.
    'C__CMDB__VIEW__MISC_WELCOME'           => 1014, // @todo  Remove in 1.21

    // Object tree node.
    'C__CMDB__TREE_NODE__BACK'              => 500001, // @todo  Remove in 1.21

    // Unused constant for search module.
    'C__SEARCH__GET__WHAT'                  => 's', // @todo  Remove in 1.21

    // @see ID-8791
    'C__RS__RIGHT_BROWSE'                   => 1,   // @todo  Remove in 26
    'C__RS__RIGHT_READ'                     => 2,   // @todo  Remove in 26
    'C__RS__RIGHT_NEW'                      => 4,   // @todo  Remove in 26
    'C__RS__RIGHT_EDIT'                     => 8,   // @todo  Remove in 26
    'C__RS__RIGHT_ARCHIVE'                  => 16,  // @todo  Remove in 26
    'C__RS__RIGHT_DELETE'                   => 32,  // @todo  Remove in 26
    'C__RS__RIGHT_PURGE'                    => 64,  // @todo  Remove in 26
    'C__RS__RIGHT_RECYCLE'                  => 128, // @todo  Remove in 26
    'C__RS__RIGHT_SALVAGE'                  => 256, // @todo  Remove in 26
    'C__RS__RIGHT_SYSOP'                    => 512, // @todo  Remove in 26

    'C__RS__ROLE__READER'                   => 1,   // @todo  Remove in 26
    'C__RS__ROLE__EDITOR'                   => 2,   // @todo  Remove in 26
    'C__RS__ROLE__AUTHOR'                   => 3,   // @todo  Remove in 26
    'C__RS__ROLE__ARCHIVAR'                 => 4,   // @todo  Remove in 26
    'C__RS__ROLE__ADMIN'                    => 5,   // @todo  Remove in 26
];

foreach ($constants as $constantName => $constantValue) {
    if (!defined($constantName)) {
        define($constantName, $constantValue);
    }
}
