<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Upload\UploadType;
use idoit\Module\JDisc\Upload\JDiscProfiles;

\idoit\Component\Autoloader::appendClassmap(include(__DIR__ . '/classmap.php'));

/* Register jdisc controller */
$GLOBALS['g_controller']['handler']['jdisc'] = [
    'class' => 'isys_handler_jdisc'
];
/* Register jdisc controller */
$GLOBALS['g_controller']['handler']['jdisc_discovery'] = [
    'class' => 'isys_handler_jdisc_discovery'
];

isys_register::factory('additional-dialog-admin-tables')
    ->set('isys_jdisc_status_list');

\idoit\Psr4AutoloaderClass::factory()
    ->addNamespace('idoit\Module\JDisc', __DIR__ . '/src/');

isys_register::factory('ajax-file-upload')
    ->set('profiles-import', (new UploadType())
        ->setUploadDirectory('/temp/')
        ->setValidExtensions(['json'])
        ->setSizeLimit(16777216) // 16 MB
        ->setCallbackAfterUpload([JDiscProfiles::class, 'processUpload']));
