<?php

namespace idoit\Module\JDisc\Graphql;

class Config
{
    private string $host = "";
    private string $query = "";
    private string $username = "";
    private string $password = "";
    private string $protocol = "http";
    private int $port = 9000;

    /**
     * @param string $host
     *
     * @return Config
     */
    public function setHost(string $host): Config
    {
        $this->host = $host;
        return $this;
    }

    /**
     * @param string $query
     *
     * @return Config
     */
    public function setQuery(string $query): Config
    {
        $this->query = $query;
        return $this;
    }

    /**
     * @param string $username
     *
     * @return Config
     */
    public function setUsername(string $username): Config
    {
        $this->username = $username;
        return $this;
    }

    /**
     * @param string $password
     *
     * @return Config
     */
    public function setPassword(string $password): Config
    {
        $this->password = $password;
        return $this;
    }

    /**
     * @param string $protocol
     *
     * @return Config
     */
    public function setProtocol(string $protocol): Config
    {
        $this->protocol = $protocol;
        return $this;
    }

    /**
     * @param int $port
     *
     * @return Config
     */
    public function setPort(int $port): Config
    {
        $this->port = $port;
        return $this;
    }

    /**
     * @return string
     */
    public function getHost(): string
    {
        return $this->host;
    }

    /**
     * @return string
     */
    public function getQuery(): string
    {
        return $this->query;
    }

    /**
     * @return string
     */
    public function getUsername(): string
    {
        return $this->username;
    }

    /**
     * @return string
     */
    public function getPassword(): string
    {
        return $this->password;
    }

    /**
     * @return string
     */
    public function getProtocol(): string
    {
        return $this->protocol;
    }

    /**
     * @return int
     */
    public function getPort(): int
    {
        return $this->port;
    }

    /**
     * @return string
     */
    public function getUrl(): string
    {
        return sprintf("%s://%s/graphql", $this->getProtocol(), $this->getHost());
    }

    /**
     * @param $host
     * @param $username
     * @param $password
     * @param $port
     * @param $protocol
     *
     * @return Config
     */
    public static function factory($host, $username, $password, $port = 9000, $protocol = 'http')
    {
        $instance = new self();
        $instance->setHost($host)
            ->setUsername($username)
            ->setPassword($password)
            ->setPort($port)
            ->setProtocol($protocol);
        return $instance;
    }
}