<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type Directory
 * A directory object */
final class DirectoryType implements AutoGenerationInterface
{
    /**
     * The directory canonical name.
     */
    public ?string $canonicalName = null;
    /**
     * The child directories.
     * @var null|iterable
     */
    public ?iterable $children = null;
    /**
     * The computer accounts associated with the directory.
     * @var null|iterable
     */
    public ?iterable $computerAccounts = null;
    /**
     * The last discovery timestamp. This is the timestamp when devices of this directory item has been scanned for the last time.
     */
    public $discoveryTime = null;
    /**
     * The directory distinguished name.
     */
    public ?string $distinguishedName = null;
    /**
     * The directory guid.
     */
    public ?string $guid = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The directory name.
     */
    public ?string $name = null;
    /**
     * The directory netbios name.
     */
    public ?string $netBiosName = null;
    /**
     * The number of computer members.
     */
    public ?int $numberOfComputerMembers = null;
    /**
     * The parent directory.
     */
    public ?DirectoryType $parentDirectory = null;
    /**
     * The directory type.
     */
    public ?DirectoryTypeEnum $type = null;
    /**
     * The directory unique id.
     */
    public ?string $uniqueId = null;
    /**
     * The list of users assigned to this directory object.
     * @var null|iterable
     */
    public ?iterable $users = null;
}