<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type PhysicalDiskInput
 * The physical disk represents a disk attached to a disk slot. * @property null|BusTypeEnum $busType = null The disk bus type.
 * @property null|string $fwVersion = null A disk's firmware version.
 * @property null|string $manufacturer = null The disk manufacturer.
 * @property null|DiskMediaTypeEnum $mediaType = null The disk media type.
 * @property null|string $model = null The disk model.
 * @property null|iterable|DiskPartitionInputInputType[] $partitions = null The list of disk partitions.
 * @property null|string $serialNumber = null The disk serialNumber.
 * @property mixed $size = null The disk size in KB.
 * @property null|DiskStatusEnum $status = null The disk status.
 */
final class PhysicalDiskInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'busType') {
            return new BusTypeEnum($value);
        }

        if ($name === 'mediaType') {
            return new DiskMediaTypeEnum($value);
        }

        if ($name === 'partitions') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DiskPartitionInputInputType($v)); })($value);
        }

        if ($name === 'status') {
            return new DiskStatusEnum($value);
        }

        return $value;
    }
}