[{isys_group name="tom.popup.translationImport"}]
    <div id="custom-translation-import">
        <div class="popup-header-ng">
            <h1>[{isys type="lang" ident="LC__LANGUAGE_ADD_TRANSLATION"}]</h1>
            <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
                <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
            </button>
        </div>
        <div class="popup-content p10">
            <table class="contentTable">
                <tr>
                    <td class="key vat">[{isys type="f_label" name="C__CUSTOM_TRANSLATION__NEW_KEY" ident="LC__LANGUAGE_ADD_TRANSLATION__KEY"}]</td>
                    <td class="value">
                        [{isys type="f_text" name="C__CUSTOM_TRANSLATION__NEW_KEY"}]
                        <p class="cb pl20 pt5 text-blue">[{isys type="lang" ident="LC__LANGUAGE_ADD_TRANSLATION__KEY_INFO"}]</p>
                    </td>
                </tr>
                <tr>
                    <td class="key">[{isys type="f_label" name="C__CUSTOM_TRANSLATION__NEW_VALUE" ident="LC__LANGUAGE_ADD_TRANSLATION__VALUE"}]</td>
                    <td class="value">[{isys type="f_text" name="C__CUSTOM_TRANSLATION__NEW_VALUE"}]</td>
                </tr>
            </table>
        </div>
        <div class="popup-footer-ng">
            <button type="button" class="btn mr5" id="custom-translation-accept-new-value">
                <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt="" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span>
            </button>

            <button type="button" class="btn popup-closer">
                <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
            </button>
        </div>
    </div>

    <script>
        (function () {
            'use strict';

            const $translationKeyInput = $('C__CUSTOM_TRANSLATION__NEW_KEY');
            const $translationValueInput = $('C__CUSTOM_TRANSLATION__NEW_VALUE');
            const $acceptButton = $('custom-translation-accept-new-value');
            const $popup = $('custom-translation-import');

            const cleanConstantString = function (str) {
                return str
                    .toUpperCase()
                    .replaceAll(/[\s-]/g, '_')
                    .replaceAll(/[^A-Z0-9_]/g, '');
            }

            $translationKeyInput.on('keydown', function (ev) {
                if (!ev.key.match(/[\sa-zA-Z0-9_-]/)) {
                    ev.preventDefault();
                }

                $translationKeyInput.setValue(cleanConstantString($translationKeyInput.getValue()));
            });

            $translationKeyInput.on('keyup', function (ev) {
                $translationKeyInput.setValue(cleanConstantString($translationKeyInput.getValue()));
            });

            $translationKeyInput.on('blur', function () {
                // Clean all underlines at the beginning and end.
                $translationKeyInput.setValue($translationKeyInput.getValue().replaceAll(/(^_*|_*$)/g, ''));
            });

            $acceptButton.on('click', function () {
                $translationKeyInput.removeClassName('input-error');

                if ($translationKeyInput.getValue().blank()) {
                    $translationKeyInput.addClassName('input-error');
                    idoit.Notify.error('[{isys type="lang" ident="LC__LANGUAGE_ADD_TRANSLATION__KEY_MANDATORY"}]', { life: 5 });
                    return;
                }

                $acceptButton
                    .disable()
                    .down('img').addClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg')
                    .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

                const translation = { };

                translation[$translationKeyInput.getValue()] = $translationValueInput.getValue();

                new Ajax.Request(window.www_dir + 'pro/translation/create-custom-translation', {
                    parameters: {
                        translation: JSON.stringify(translation)
                    },
                    method:     'post',
                    onSuccess:  function (xhr) {
                        const json = xhr.responseJSON;

                        $acceptButton
                            .enable()
                            .down('img').removeClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/basic/symbol-ok.svg')
                            .next('span').update('[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]');

                        if (!is_json_response(xhr, true)) {
                            return;
                        }

                        if (!json.success) {
                            idoit.Notify.error(json.message, { sticky: true });

                            return;
                        }

                        idoit.Notify.success('[{isys type="lang" ident="LC__INFOBOX__DATA_WAS_SAVED"}]', { life: 5 });

                        popup_close();
                    }
                });
            });

            $popup.on('click', '.popup-closer', function () {
                popup_close();
            });

            $('body').fire('update:tooltips');
        })();
    </script>
[{/isys_group}]
