<div class="p10">
	<h3>[{isys type="lang" ident="LC__MODULE__IMPORT__LDAP__HEADLINE"}]</h3>
	<p>[{isys type="lang" ident="LC__MODULE__IMPORT__LDAP__DESCRIPTION"}]</p>
</div>
[{if $ldap_is_installed}]
    <fieldset class="overview">
        <legend><span>Server</span></legend>
        <table class="contentTable m10">
            <tr>
                <td class="key">[{isys type="f_label" name="C__LDAP_IMPORT__LDAP_SERVERS" ident="LDAP Server"}]</td>
                <td class="value">[{isys type="f_dialog" name="C__LDAP_IMPORT__LDAP_SERVERS" id="C__LDAP_IMPORT__LDAP_SERVERS"}]</td>
            </tr>
            <tr>
                <td class="key">[{isys type="f_label" name="C__LDAP_IMPORT__LDAP_DN" ident="LDAP - DN"}]</td>
                <td class="value">[{isys type="f_text" name="C__LDAP_IMPORT__LDAP_DN" id="C__LDAP_IMPORT__LDAP_DN"}]</td>
            </tr>
        </table>
        <div class="m10">
            [{isys type="f_button" name="filter_check" p_strValue="LC__UNIVERSAL__READ_DIRECTORY" icon="`$dir_images`icons/silk/arrow_down.png"}]
        </div>
    </fieldset>

    <fieldset class="overview hide" id="result_fieldset">
        <legend><span>[{isys type="lang" ident="LC__MODULE__JDISC__IMPORT__RESULT"}]</span></legend>

        <button type="button" class="btn import-button m10">
            <img src="[{$dir_images}]/icons/silk/database_copy.png" class="mr5" />
            <span>[{isys type="lang" ident="LC__MODULE__LDAP__START_IMPORT"}]</span>
        </button>

        <div class="mt5 mb5 border-top border-bottom">
            <table class="listing">
                <thead>
                <tr>
                    <th width="10%"><input type="checkbox" id="mark_all" /></th>
                    <th>[{isys type="lang" ident="LC__UNIVERSAL__TITLE"}]</th>
                    <th>[{isys type="lang" ident="LC__UNIVERSAL__OBJECT_TYPE"}]</th>
                </tr>
                </thead>
                <tbody id="result" class="mouse-pointer">
                    <!-- To be filled by JS -->
                </tbody>
            </table>
        </div>

        <button type="button" class="btn import-button m10">
            <img src="[{$dir_images}]/icons/silk/database_copy.png" class="mr5" />
            <span>[{isys type="lang" ident="LC__MODULE__LDAP__START_IMPORT"}]</span>
        </button>
    </fieldset>
[{/if}]

[{if $error_message}]
<div class="m5 p10 box-red">
	[{$error_message}]
</div>
[{/if}]

<fieldset class="m5 hide" id="result_output">
	<div style="height:20px;">
		<div id="loader" class="m5 hide"></div>
	</div>

	<pre></pre>
</fieldset>

<script type="text/javascript">
	(function () {
		'use strict';

		const $readDirectoryButton = $('filter_check');
		const $importFieldset = $('result_fieldset');
		const $importTable = $('result');
		const $markAllCheckbox = $('mark_all');

        $readDirectoryButton.on('click', function () {
            $readDirectoryButton.disable()
				.down('img').writeAttribute('src', '[{$dir_images}]ajax-loading.gif')
				.next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

			new Ajax.Request('?call=ldap_import&ajax=1&func=filter', {
					parameters: {
						ldap_dn: $F('C__LDAP_IMPORT__LDAP_DN'),
						ldap_server: $F('C__LDAP_IMPORT__LDAP_SERVERS')
					},
					method: "post",
					onSuccess: function (transport) {
                        const json = transport.responseJSON;
					    let i;

                        $importTable.update();

                        for (i in json) {
                            if (!json.hasOwnProperty(i)) {
                                continue;
                            }

                            $importTable
                                .insert(new Element('tr')
                                    .update(new Element('td')
                                        .update(new Element('input', {type: 'checkbox', name: 'ldap_objects[]', value: json[i].id, checked: true})))
                                    .insert(new Element('td').update(json[i].title))
                                    .insert(new Element('td').update(json[i].type))
                                );
                        }

                        $markAllCheckbox.setValue(1);
                        $importFieldset.removeClassName('hide');
					},
					onComplete: function () {
                        $readDirectoryButton.enable()
							.down('img').writeAttribute('src', '[{$dir_images}]icons/silk/arrow_down.png')
							.next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__READ_DIRECTORY"}]');
					}
				}
			);
		});

        $markAllCheckbox.on('click', function () {
            $importTable.select('input').invoke('setValue', this.checked ? 1 : 0);
		});

        $importTable.on('click', 'td', function(ev) {
            if (!ev.findElement().match('input')) {
                const $input = ev.findElement('tr').down('input');

                $input.setValue($input.checked ? 0 : 1);
            }
        })

        $importFieldset.select('.import-button').invoke('on', 'click', function () {
            const selectedRows = $importTable.select('input:checked');

            if (selectedRows.length) {
                $('result_output').removeClassName('hide');
                $('loader').removeClassName('hide')
                    .update(new Element('img', {src:'[{$dir_images}]ajax-loading.gif', className:'mr5 vam'}))
                    .insert(new Element('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]'));

                new Ajax.Request('?call=ldap_import&ajax=1&func=import', {
                        parameters: {
                            ids:         JSON.stringify(selectedRows.invoke('getValue')),
                            ldap_dn:     $F('C__LDAP_IMPORT__LDAP_DN'),
                            ldap_server: $F('C__LDAP_IMPORT__LDAP_SERVERS')
                        },
                        method:     'post',
                        onSuccess:  function (transport) {
                            $('loader').addClassName('hide')
                            $('result_output').down('pre').update(transport.responseText);
                        }
                    }
                );
            } else {
                alert('[{isys type="lang" ident="LC__BROWSER__NO_SELECTION"}]');
            }
        });
	})();
</script>
