<?php

/**
 * i-doit
 *
 * Floorplan selection popup.
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.5.0
 */
class isys_popup_qcw_profiles extends isys_popup_qcw_adjust
{
    /**
     * Handle specific ajax requests.
     *
     * @param   isys_module_request $p_modreq
     *
     * @return  mixed
     * @author  Leonard Fischer <lfischer@i-doit.org>
     * @throws  isys_exception_objectbrowser
     */
    public function &handle_ajax_request(isys_module_request $p_modreq)
    {
        header('Content-Type: application/json');

        $response = [
            'success' => true,
            'data'    => null,
            'message' => null
        ];

        try {
            switch ($_POST['action']) {
                case 'saveProfile':
                    $response['data'] = basename(isys_module_quick_configuration_wizard::factory()
                        ->generate_export($_POST['profileTitle']));
                    break;

                case 'deleteProfile':
                    $response['data'] = isys_module_quick_configuration_wizard::delete_config_file($_POST['file']);
                    break;
            }

            // The file uploader will not send POST data :(
            switch ($_GET['action']) {
                case 'upload':
                    $response['data'] = $this->upload_profile_xml();
                    break;
            }
        } catch (Exception $e) {
            $response['success'] = false;
            $response['message'] = $e->getMessage();
        }

        echo \isys_format_json::encode($response);
        die;
    }

    /**
     * Handles a profile XML file upload.
     *
     * @return  array
     * @throws  isys_exception_filesystem
     */
    protected function upload_profile_xml()
    {
        $uploadDir = isys_module_quick_configuration_wizard::getProfilePath();
        $uploader = new isys_library_fileupload(['xml']);
        $filename = $uploader->getName();

        $result = $uploader->handleUpload($uploadDir);

        if ($result['success'] !== true || (isset($result['error']) && !empty($result['error']))) {
            throw new isys_exception_filesystem($result['error']);
        }

        // If the "just uploaded" file could not be found, we throw an error.
        if (!file_exists($uploadDir . $filename)) {
            throw new isys_exception_filesystem($result['error']);
        }

        $result['filename'] = $filename;

        return $result;
    }

    /**
     * Method for handling the module request.
     *
     * @param   isys_module_request $p_modreq
     *
     * @return  void
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        parent::handle_module_request($p_modreq);

        $downloadLink = isys_helper_link::create_url([
            C__GET__MODULE_ID     => defined_or_default('C__MODULE__SYSTEM'),
            C__GET__MODULE_SUB_ID => defined_or_default('C__MODULE__QCW'),
            'dl'                  => ''
        ]);

        $rules = [
            'C__MODULE__QCW__CONFIG_TITLE' => [
                'p_strClass'        => 'mt10 mb10 input-block',
                'nowiki'            => true,
                'p_bInfoIconSpacer' => 0,
                'p_strPlaceholder'  => 'LC__MODULE__QCW__NAME'
            ]
        ];

        $this->template->assign('profiles', isys_format_json::encode(isys_module_quick_configuration_wizard::get_config_files()))
            ->assign('download_link', $downloadLink)
            ->smarty_tom_add_rules('tom.popup.qcw', $rules)
            ->display(isys_module_quick_configuration_wizard::getPath() . 'templates/popup/popupProfiles.tpl');

        die;
    }
}
