<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type Processor
 * The processor represents a processor within a processor slot on the mainboard. */
final class ProcessorType implements AutoGenerationInterface
{
    /**
     * The processor address width.
     */
    public ?int $addressWidth = null;
    /**
     * The current clock speed at the time of the scan in Mhz
     */
    public ?int $currentClockSpeed = null;
    /**
     * The processor data width.
     */
    public ?int $dataWidth = null;
    /**
     * The processor device id.
     */
    public ?string $devID = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The processor level 2 cache size.
     */
    public ?int $l2CacheSize = null;
    /**
     * The processor level 2 cache speed.
     */
    public ?int $l2CacheSpeed = null;
    /**
     * The processor level 3 cache size.
     */
    public ?int $l3CacheSize = null;
    /**
     * The processor level 3 cache speed.
     */
    public ?int $l3CacheSpeed = null;
    /**
     * The processor manufacturer.
     */
    public ?string $manufacturer = null;
    /**
     * The maximal clock speed at the time of the scan in Mhz
     */
    public ?int $maxClockSpeed = null;
    /**
     * The processor model.
     */
    public ?string $model = null;
    /**
     * The number of cores.
     */
    public ?int $numberOfCores = null;
    /**
     * The number of enabled cores. Some servers allow to disable cores.
For instance to be license compliant for software that is licensed per core.
     */
    public ?int $numberOfEnabledCores = null;
    /**
     * The number of threads.
     */
    public ?int $numberOfThreads = null;
    /**
     * The processor raw model as it comes from the BIOS information.
     */
    public ?string $rawModel = null;
    /**
     * The maximal clock speed at the time of the scan in Mhz
     */
    public ?ProcessorStatusEnum $status = null;
}