<?php

use idoit\Module\Pro\SettingPage\CustomTranslation\CustomTranslation;
use idoit\Module\System\SettingPage\AttributeVisibility\AttributeVisibility;

/**
 * i-doit
 *
 * Pro module class.
 *
 * @package     i-doit
 * @subpackage  modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_pro extends isys_module
{
    // Define, if this module shall be displayed in the named menus.
    const DISPLAY_IN_MAIN_MENU   = false;
    const DISPLAY_IN_SYSTEM_MENU = false;
    const MAIN_MENU_REWRITE_LINK = false;

    /**
     * Callback function for construction of breadcrumb navigation.
     *
     * @param array $gets
     *
     * @return array|null
     * @throws isys_exception_database
     */
    public function breadcrumb_get(&$gets)
    {
        $dataViewMapping = [
            'attribute-visibility' => 'LC__CMDB__TREE__SYSTEM__ATTRIBUTE_VISIBILITY',
            'custom-translations' => 'LC__CUSTOM_TRANSLATIONS'
        ];

        if (isset($dataViewMapping[$gets[C__GET__SETTINGS_PAGE]])) {
            return [
                [
                    $this->language->get('LC__MODULE__SYSTEM__TREE__DATA_VIEW') => [
                        C__GET__MODULE_ID     => C__MODULE__SYSTEM,
                        C__GET__MODULE_SUB_ID => C__MODULE__PRO,
                        C__GET__SETTINGS_PAGE => $gets[C__GET__SETTINGS_PAGE]
                    ]
                ],
                [
                    $this->language->get($dataViewMapping[$gets[C__GET__SETTINGS_PAGE]]) => null
                ]
            ];
        }

        return null;
    }

    /**
     * @return void
     */
    public function start()
    {
        $template = isys_application::instance()->container->get('template');
        $database = isys_application::instance()->container->get('database');
        $navMode = (int) ($_POST[C__GET__NAVMODE] ?: $_GET[C__GET__NAVMODE]);

        // Nothing to do
        if (isset($_GET[C__GET__SETTINGS_PAGE])) {
            if ($_GET[C__GET__SETTINGS_PAGE] === 'custom-translations') {
                (new CustomTranslation($template, $database, $this->language))->renderPage($navMode);
            }

            if ($_GET[C__GET__SETTINGS_PAGE] === 'attribute-visibility') {
                (new AttributeVisibility($template, $database, $this->language))->renderPage($navMode);
            }
        }
    }

    /**
     * Initializes the module.
     *
     * @param isys_module_request $p_req
     */
    public function init(isys_module_request $p_req)
    {
        // Nothing to do
    }

    /**
     * @param isys_component_tree $tree
     * @param int                 $parentId
     *
     * @return void
     * @throws Exception
     */
    public static function extendDataViewTree(isys_component_tree $tree, int $parentId): void
    {
        $imageDir = isys_application::instance()->www_path . 'images/axialis/';
        $language = isys_application::instance()->container->get('language');

        if (isys_module_cmdb::getAuth()->is_allowed_to(isys_auth::VIEW, 'attribute_visibility')) {
            $currentCount = $tree->count() + 1;

            $tree->add_node(
                $currentCount,
                $parentId,
                $language->get('LC__CMDB__TREE__SYSTEM__ATTRIBUTE_VISIBILITY'),
                isys_helper_link::create_url([
                    C__GET__MODULE_ID     => C__MODULE__SYSTEM,
                    C__GET__MODULE_SUB_ID => C__MODULE__PRO,
                    C__GET__SETTINGS_PAGE => 'attribute-visibility'
                ]),
                '',
                "{$imageDir}basic/eye.svg",
                $_GET[C__GET__MODULE_ID] == C__MODULE__SYSTEM && $_GET[C__GET__MODULE_SUB_ID] == C__MODULE__PRO && $_GET[C__GET__SETTINGS_PAGE] === 'attribute-visibility'
            );
        }

        if (isys_module_system::getAuth()->is_allowed_to(isys_auth::VIEW, 'custom-translations')) {
            $currentCount = $tree->count() + 1;

            $tree->add_node(
                $currentCount,
                $parentId,
                $language->get('LC__CUSTOM_TRANSLATIONS'),
                isys_helper_link::create_url([
                    C__GET__MODULE_ID     => C__MODULE__SYSTEM,
                    C__GET__MODULE_SUB_ID => C__MODULE__PRO,
                    C__GET__SETTINGS_PAGE => 'custom-translations'
                ]),
                '',
                "{$imageDir}flags-languages/application-language.svg",
                $_GET[C__GET__MODULE_ID] == C__MODULE__SYSTEM && $_GET[C__GET__MODULE_SUB_ID] == C__MODULE__PRO && $_GET[C__GET__SETTINGS_PAGE] === 'custom-translations'
            );
        }
    }
}
