<?php

namespace idoit\Module\System\Cleanup;

use isys_application;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class AbstractCleanup
 *
 * @package idoit\Module\System\Cleanup
 */
abstract class AbstractCleanup
{
    /**
     * @var ContainerBuilder
     */
    protected $container;

    /**
     * AbstractCleanup constructor.
     */
    public function __construct()
    {
        $this->container = isys_application::instance()->container;
    }

    /**
     * Method for starting the cleanup process.
     */
    abstract public function process();
}
