<?php
/**
 * @package    i-doit
 * @subpackage General
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
global $g_comp_database_system;

use idoit\Component\Helper\Unserialize;
use idoit\Module\Cmdb\Model\Ci\Table\Config;
use idoit\Module\Cmdb\Model\Ci\Table\Property;

if (!isys_settings::is_initialized()) {
    isys_settings::initialize($g_comp_database_system);
}

if (isset($_GET['expert'])) {
    if (isset($_GET['action']) && $_GET['action'] === 'save') {
        $l_result = [
            'success' => true,
            'message' => 'Config successfully overwritten, page will reload.'
        ];

        try {
            $rawSettings = json_decode($_POST['settings'], true);

            $removeSettingsKeys = array_map(function ($key) {
                return substr($key, 8);
            }, array_keys(array_filter($rawSettings, function ($value, $key) {
                return (strpos($key, 'remove__') === 0 && $value == '1');
            }, ARRAY_FILTER_USE_BOTH)));

            $updateSettings = array_filter($rawSettings, function ($key) use ($removeSettingsKeys) {
                return strpos($key, 'setting__') === 0 && !in_array(substr($key, 9), $removeSettingsKeys, true);
            }, ARRAY_FILTER_USE_KEY);

            $createSettings = [];

            if (isset($rawSettings['custom__key[]']) && is_array($rawSettings['custom__key[]'])) {
                foreach ($rawSettings['custom__key[]'] as $index => $key) {
                    if (!isset($rawSettings['custom__value[]'][$index]) || trim($rawSettings['custom__value[]'][$index]) === '' || trim($key) === '') {
                        continue;
                    }

                    $createSettings[$key] = $rawSettings['custom__value[]'][$index];
                }
            } elseif (isset($rawSettings['custom__key[]']) && is_string($rawSettings['custom__key[]']) && is_string($rawSettings['custom__value[]'])) {
                if (trim($rawSettings['custom__key[]']) !== '' && trim($rawSettings['custom__value[]']) !== '') {
                    $createSettings[$rawSettings['custom__key[]']] = $rawSettings['custom__value[]'];
                }
            }

            foreach ($removeSettingsKeys as $key) {
                isys_settings::remove($key);
            }

            foreach ($updateSettings as $key => $value) {
                isys_settings::set(substr($key, 9), $value);
            }

            foreach ($createSettings as $key => $value) {
                isys_settings::set($key, $value);
            }

            isys_settings::force_save();
        } catch (Exception $e) {
            $l_result['success'] = false;
            $l_result['message'] = $e->getMessage();
        }

        header('Content-Type: application/json');
        echo json_encode($l_result);
        die;
    }

    function isInternalSetting($settingKey, $settingValue): bool
    {
        $internalConfigurationKeys = [
            'system.start-of-end',
            'cmdb.objtype-',
            'cmdb.object-browser.C__',
            'cmdb.base-object-list.config.C__',
            'cmdb.base-object-table.config.C__',
        ];

        try {
            if (strpos($settingKey, 'admin.') === 0) {
                return true;
            }

            foreach ($internalConfigurationKeys as $key) {
                if (strpos($settingKey, $key) !== false) {
                    // If we find a "internal" configuration jump out immediately!
                    return true;
                }
            }

            if (is_scalar($settingValue)) {
                if (!$settingValue) {
                    return false;
                }

                // @see ID-9433 Only allow specific classes to be unserialized.
                if (!Unserialize::toObject($settingValue, [Config::class, Property::class]) instanceof stdClass) {
                    return true;
                }

                if (isys_format_json::is_json($settingValue) && !is_scalar(isys_format_json::decode($settingValue))) {
                    return true;
                }
            }
        } catch (Exception $e) {
        }

        return false;
    }

    $settings = isys_settings::get();

    foreach ($settings as $l_key => $l_value) {
        if (!isInternalSetting($l_key, $l_value)) {
            $settings[$l_key] = isys_glob_htmlentities($l_value);
        }
    }

    // Strip html again, append necessary tags when saving
    $settings['system.login.welcome-message'] = filter_var($settings['system.login.welcome-message'], FILTER_SANITIZE_STRING);

    // Necessary 'hack' to include a different template.
    $_GET["req"] = 'settings-expert';

    isys_component_template::instance()
        ->assign('settings', $settings);
} else {
    if (isset($_GET['action']) && $_GET['action'] === 'save') {
        $l_result = [
            'success' => true,
            'message' => 'Config successfully overwritten.'
        ];

        try {
            $settingsData = array_filter(json_decode($_POST['settings'], true), function ($key) {
                return strpos($key, 'setting__') === 0;
            }, ARRAY_FILTER_USE_KEY);

            foreach ($settingsData as $key => $value) {
                isys_settings::set(substr($key, 9), $value);
            }

            isys_settings::force_save();
        } catch (Exception $e) {
            $l_result['success'] = false;
            $l_result['message'] = $e->getMessage();
        }

        header('Content-Type: application/json');
        echo json_encode($l_result);
        die;
    }

    $language = isys_application::instance()->container->get('language');

    $sortedDefinition = [];
    $definition = isys_settings::get_definition();

    foreach ($definition as $topic => $settings) {
        $settings = array_filter($settings, fn ($setting) => !(isset($setting['hidden']) && $setting['hidden']));

        if (count($settings)) {
            $sortedDefinition[$language->get($topic)] = $settings;
        }
    }

    $tenantResult = isys_component_dao_mandator::instance($g_comp_database_system)->get_mandator();

    while ($row = $tenantResult->get_row()) {
        $sortedDefinition['Single Sign On']['session.sso.mandator-id']['options'][$row['isys_mandator__id']] = $row['isys_mandator__title'];
    }

    ksort($sortedDefinition);

    isys_component_template::instance()
        ->assign('definition', $sortedDefinition)
        ->assign('settings', isys_settings::get());
}
