<?php

/**
 * i-doit
 *
 * DAO: ObjectType list for access.
 *
 * @package     i-doit
 * @subpackage  CMDB_Category_lists
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_list_catg_cards extends isys_component_dao_category_table_list implements isys_cmdb_dao_list_interface
{
    /**
     * Return constant of category.
     *
     * @return  integer
     */
    public function get_category()
    {
        return defined_or_default('C__CATG__CARDS');
    }

    /**
     * Return constant of category type.
     *
     * @return  integer
     */
    public function get_category_type()
    {
        return C__CMDB__CATEGORY__TYPE_GLOBAL;
    }

    public function modify_row(&$row)
    {
        if (isset($row['isys_obj__id']) && $row['isys_obj__id']) {
            $row['assigned_card'] = isys_ajax_handler_quick_info::instance()
                ->getQuickInfoReplacement($row['isys_obj__id'], $row['isys_obj__title']);
        }
    }

    /**
     * Method for receiving the field names.
     *
     * @return  array
     */
    public function get_fields()
    {
        return [
            'isys_catg_cards_list__id'            => 'LC__UNIVERSAL__ID',
            'isys_catg_cards_list__title'         => 'LC__CMDB__CATG__CARDS__TITLE',
            'assigned_card'                       => 'LC__CMDB__CATS__SIM_CARD__ASSIGNED_MOBILE_PHONE',
            'isys_catg_cards_list__card_number'   => 'LC__CMDB__CATS_CP_CONTRACT__CARD_NUMBER',
            'isys_catg_cards_list__pin'           => 'LC__CMDB__CATS_CP_CONTRACT__PIN',
            'isys_catg_cards_list__pin2'          => 'LC__CMDB__CATS_CP_CONTRACT__PIN2',
            'isys_catg_cards_list__puk'           => 'LC__CMDB__CATS_CP_CONTRACT__PUK',
            'isys_catg_cards_list__puk2'          => 'LC__CMDB__CATS_CP_CONTRACT__PUK2',
            'isys_catg_cards_list__serial_number' => 'LC__CMDB__CATG__SERIAL',
            'isys_catg_cards_list__description'   => 'LC__CMDB__CATG__DESCRIPTION',
        ];
    }
}
