<?php

namespace idoit\Module\Cmdb\Component\SyncNormalizer;

use Exception;
use idoit\Component\Property\Property;
use isys_application;
use isys_cmdb_dao_category;

class Normalizer
{
    /**
     * @var Config
     */
    protected Config $config;

    /**
     * @param Config $config
     */
    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    /**
     * @param isys_cmdb_dao_category $dao
     * @param int                    $objectId
     * @param int|null               $entryId
     *
     * @return array
     */
    private function getCategoryData(isys_cmdb_dao_category $dao, int $objectId, ?int $entryId = null)
    {
        if (!$dao->is_multivalued()) {
            return $dao->get_data(null, $objectId)->get_row() ?? [];
        }

        if ($entryId) {
            return $dao->get_data($entryId)->get_row() ?? [];
        }

        return [];
    }

    /**
     * @param int      $objectId
     * @param int|null $entryId
     *
     * @return array
     */
    public function normalizeData(int $objectId, ?int $entryId = null): array
    {
        $dao = $this->config->getDao();
        $properties = $dao->get_properties();
        $data = $this->config->getData();
        $categoryData = [];

        foreach ($properties as $propertyKey => &$property) {
            if (is_array($property)) {
                $property = Property::createInstanceFromArray($property);
            }
        }
        $categoryData = $this->getCategoryData($dao, $objectId, $entryId);

        $dataNormalizerProvider = new DataNormalizerProvider(new DataNormalizerProviderConfig($properties, $objectId, $entryId, $categoryData));

        $order = array_keys($properties);

        uksort($data, function ($propertyKey1, $propertyKey2) use ($order) {
            return ((array_search($propertyKey1, $order) > array_search($propertyKey2, $order)) ? 1 : -1);
        });

        /** @var Property[] $properties **/
        $data = array_filter($data, function ($key) use ($properties) {
            if ($properties[$key] && $properties[$key]->getProvides()->isImport()) {
                return true;
            }

            // @todo logging that the property can not be used to in the sync

            return false;
        }, ARRAY_FILTER_USE_KEY);

        foreach ($data as $propertyKey => &$value) {
            if (!isset($properties[$propertyKey])) {
                // Property from the request does not exist
                continue;
            }

            $dataNormalizerProvider->normalizeData($propertyKey, $data, $value);
        }

        return $data;
    }
}
