<?php

declare (strict_types=1);
namespace Axtiva\FlexibleGraphql\Example\GraphQL\Resolver\Query;

use Axtiva\FlexibleGraphql\Example\GraphQL\Model\CodedCurrencyType;
use Axtiva\FlexibleGraphql\Example\GraphQL\Model\NamedCurrencyType;
use GraphQL\Type\Definition\ResolveInfo;
use Axtiva\FlexibleGraphql\Resolver\ResolverInterface;
use Axtiva\FlexibleGraphql\Example\GraphQL\ResolverArgs\Query\AccountResolverArgs;
use Axtiva\FlexibleGraphql\Example\GraphQL\Model\AccountType;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * This is resolver for Query.account
 */
final class AccountResolver implements ResolverInterface
{
    /**
     * @param $rootValue
     * @param AccountResolverArgs $args
     * @param $context
     * @param ResolveInfo $info
     * @return ?AccountType
     */
    public function __invoke($rootValue, $args, $context, ResolveInfo $info)
    {
        $model = new \Axtiva\FlexibleGraphql\Example\GraphQL\Model\AccountType();
        $model->id  = $args['id'];
        $model->number = 'fdasf32dsfasge3';

        $namedCurrency = new NamedCurrencyType();
        $namedCurrency->id = '32';
        $namedCurrency->name = 'DemoName';

        $codedCurrency = new CodedCurrencyType(42, 323);
        $codedCurrency->id = '42';
        $codedCurrency->code = 42;

        $model->currency = rand(0,1) ? $namedCurrency : $codedCurrency;
        return $model;
    }
}