<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Resolver\Mutation;

use Axtiva\FlexibleGraphql\Generator\Exception\NotImplementedResolver;
use GraphQL\Type\Definition\ResolveInfo;
use Axtiva\FlexibleGraphql\Resolver\ResolverInterface;
use idoit\Module\JDisc\Graphql\Schema\Model\LoginLogoutType;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * This is resolver for Mutation.authentication
 * This is the primary authentication interface used to login and logout.

A login call requires a username and a password for the authentication. On successful authentication, the call returns an
 - access token
 - renewal token

The access token must be added to the HTTPS request headers to ensure a user has access to the appropriate resources.
An access token has usually a limited lifetime. This is done for various security reasons: for one, limiting the lifetime
of the access token limits the amount of time an attacker can use a stolen token. In addition, the information contained
in or referenced by the access token could become stale.
When access tokens expire or become invalid but the application still needs to access a protected resource, the application
faces the problem of getting a new access token without forcing the user to once again grant permission. To solve this problem,
a refresh token is introduced. A refresh token allows an application to obtain a new access token without prompting the user.

The access token must be added into the HTTPS header as parameter "Authorization". The value must be the String "Bearer"
followed by a space and the access token. When the access token has expired, then the server returns an SC_UNAUTHORIZED (401)
In this case, you might use the refresh token to obtain a new access and refresh token using the refreshAccessToken call.
The GraphQL also returns an SC_UNAUTHORIZED (401) when the renewal token has expired. */
final class AuthenticationResolver implements ResolverInterface
{
    /**
     * @param $rootValue
     * @param $args
     * @param $context
     * @param ResolveInfo $info
     * @return LoginLogoutType
     */
    public function __invoke($rootValue, $args, $context, ResolveInfo $info)
    {
        throw new NotImplementedResolver('Not implemented field resolver ' . __CLASS__);
    }
}