<?php
/**
 * i-doit
 *
 * i-doit Starter
 *
 * @package     i-doit
 * @subpackage  General
 * @author      i-doit-team
 * @version     0.9
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Helper\Purify;

try {
    global $g_dirs, $g_comp_database, $g_config, $g_comp_session;

    // @see ID-9592 The next few lines will redirect the user, if one (or more) GET parameter key seems to be malicious.
    $newParams = [];
    $reload = false;

    array_walk($_GET, function ($value, $key) use (&$newParams, &$reload) {
        $newKey = Purify::purifyValue($key);
        $newValue = Purify::purifyValue($value);

        if (strlen($newKey) !== strlen($key)) {
            $reload = true;
        }

        $newParams[$newKey] = $newValue;
    });

    // @see ID-9592 If any keys where changed, this will trigger a redirect.
    if ($reload) {
        header('Location: ' . isys_helper_link::create_url($newParams));
        die;
    }

    // Set default form-action.
    $_SERVER['QUERY_STRING'] = isys_helper_link::remove_params_from_url($_SERVER['QUERY_STRING'], C__GET__AJAX_CALL);

    // Initialize navbar.
    $g_comp_template_navbar = isys_component_template_navbar::getInstance()
        ->set_save_mode(isys_tenantsettings::get('cmdb.registry.quicksave', 1) ? 'quick' : 'log');

    // Global array for URL parameters which mustn't get deleted.
    $g_arSaveURLParameters = [
        "mNavID",
        "SMARTY_DEBUG",
        "bvMode"
    ];

    $getParams = Purify::purifyParams($newParams);

    /**
     * Include main navigation.
     *
     * @todo  isys_mainnavi need a place in the i-doit structure.
     * @todo  isys_mainnavi is plain and not dynamic.
     */
    if (!isset($g_ajax) || !$g_ajax) {
        include_once $g_dirs['utils'] . 'isys_mainnavi.inc.php';
    }

    // Store status array.
    if ($_POST['cmdb_status']) {
        // @see ID-9393 Clean the values, we only accept integers.
        $cmdbStatus = array_map('intval', $_POST['cmdb_status']);

        $_SESSION['cmdb_status'] = $cmdbStatus;

        // @see ID-6409 Save CMDB-Status filter for a user.
        if (isys_tenantsettings::get('cmdb.gui.remember-cmdb-status', false)) {
            isys_usersettings::set('cmdb.gui.mydoit-cmdb-status-0', $cmdbStatus[0] ?: 0);
            isys_usersettings::set('cmdb.gui.mydoit-cmdb-status-1', $cmdbStatus[1] ?: 0);
            isys_usersettings::set('cmdb.gui.mydoit-cmdb-status-2', $cmdbStatus[2] ?: 0);
        }
    }

    if (!isset($_SESSION['cmdb_status']) || !is_array($_SESSION['cmdb_status'])) {
        // Set default status.
        $_SESSION['cmdb_status'] = [
            0,
            0,
            0
        ];

        // @see ID-6409 Save CMDB-Status filter for a user.
        if (isys_tenantsettings::get('cmdb.gui.remember-cmdb-status', false)) {
            $_SESSION['cmdb_status'][0] = isys_usersettings::get('cmdb.gui.mydoit-cmdb-status-0', 0);
            $_SESSION['cmdb_status'][1] = isys_usersettings::get('cmdb.gui.mydoit-cmdb-status-1', 0);
            $_SESSION['cmdb_status'][2] = isys_usersettings::get('cmdb.gui.mydoit-cmdb-status-2', 0);
        }
    }

    // Write cRecStatusListView to session.
    if (isys_glob_get_param("cRecStatus")) {
        $_SESSION['cRecStatusListView'] = isys_glob_get_param("cRecStatus");
    } else {
        // Is there a value in the session?
        if (!isset($_SESSION['cRecStatusListView'])) {
            // Set default value
            $_SESSION['cRecStatusListView'] = C__RECORD_STATUS__NORMAL;
        } elseif ($_SESSION['cRecStatusListView'] > C__RECORD_STATUS__DELETED) {
            if ($getParams[C__CMDB__GET__VIEWMODE] == C__CMDB__VIEW__LIST_CATEGORY) {
                $_SESSION['cRecStatusListView'] = C__RECORD_STATUS__NORMAL;
            } elseif ($getParams[C__CMDB__GET__VIEWMODE] == C__CMDB__VIEW__LIST_OBJECT && $_SESSION['cRecStatusListView'] != C__RECORD_STATUS__TEMPLATE) {
                $_SESSION['cRecStatusListView'] = C__RECORD_STATUS__NORMAL;
            }
        }
    }

    // CMDB-SPECIFIC - Set object-type id, if not existent in _GET parameters.
    if (empty($getParams[C__CMDB__GET__OBJECTTYPE]) && isset($getParams[C__CMDB__GET__OBJECT])) {
        if (class_exists("isys_cmdb_dao")) {
            $l_dao_cmdb = new isys_cmdb_dao($g_comp_database);

            $_GET[C__CMDB__GET__OBJECTTYPE] = $l_dao_cmdb->get_objTypeID($getParams[C__CMDB__GET__OBJECT]);
            unset($l_dao_cmdb);
        }
    }

    /**
     * Include Applicaiton controllerp
     */
    include_once('application.inc.php');
} catch (isys_exception_general $e) {
    isys_glob_display_error($e->getMessage());
    die();
}
