<?php

namespace idoit\Module\JDisc\Graphql\Query;

use GraphQL\Query;
use GraphQL\Results;
use idoit\Module\JDisc\Graphql\AbstractGraphql;
use idoit\Module\JDisc\Graphql\ResponseInterface;
use idoit\Module\JDisc\Graphql\Type\DeviceInputType;

// example:
//
// $connector = Connector::instance($serverId);
// $connector->connect();
// $query = new IdentifyDevice();
// $query->setParameters([
//     new DeviceInputType(
//         'device',
//         [
//             'type'              => 'Switch',
//             'serialNumber'      => 'abcd',
//             'networkInterfaces' => [
//                 ['physicalAddress' => '00:00:00:00:00:00'],
//             ],
//         ]
//     ),
// ]);
// $connector->query($query)

class IdentifyDevice extends AbstractGraphql implements ResponseInterface
{
    /**
     * @var DeviceInputType
     */
    private ?DeviceInputType $device;

    /**
     * @param DeviceInputType $device
     */
    public function setDevice(DeviceInputType $device): void
    {
        $this->device = $device;
    }

    public function getParameters(): array
    {
        return [];
    }

    public function getSelections(): array
    {
        return [];
    }

    public static function getDataFromResults(Results $results): array
    {
        $data = $results->getData();
        return [
            'device' => $data['importing']['devices']['identifyDevice']['foundDevice'] ?: [],
        ];
    }

    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        return (new Query('
            importing {
                devices {
                    identifyDevice(device: ' . $this->device->getFormattedValue() . ') {
                        foundDevice {
                            id,
                            name
                        }
                    }
                }
            }
        '));
    }
}
