<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type DeviceGroupInput
 * A device group can be used to group devices by different aspects (network membership, basic device properties etc.). * @property null|bool $assignDirectlyAttachedDevices = null A flag whether to also assign directly attached devices of group members to the group (e.g. attached monitors)
 * @property null|iterable|DeviceGroupInputInputType[] $children = null The child directories.
 * @property null|string $description = null The device group's description.
 * @property null|iterable|DeviceInputInputType[] $devices = null Returns the list of devices assigned to the group. Note that the root group has implicitly all devices assigned to it. Therefore, the root group will always return an empty set of devices (this is a JPA limitation which we might find a workaround in future versions)
 * @property null|string $name = null The device group's name.
 * @property null|DeviceGroupInputInputType $parentDeviceGroup = null The parent device group.
 * @property null|DeviceGroupTypeEnum $type = null The device group's type.
 * @property null|bool $useDefaultAccountsForUnknown = null A flag whether to use the default accounts from all Unix platforms for unknown devices.
 * @property null|iterable|DirectoryInputInputType[] $definingDirectoryItems = null Gets the list of directory items that make up this definition
 * @property null|iterable|IP4NetworkInputInputType[] $definingIP4Networks = null Gets the list of IP4 networks that make up this definition
 * @property null|iterable|IP6NetworkInputInputType[] $definingIP6Networks = null Gets the list of IP6 networks that make up this definition
 * @property null|iterable|NetworkNeighborhoodInputInputType[] $definingNetworkNeighborhoods = null Gets the list of network neighborhoods (domains or workgroups) that make up this definition
 * @property bool $isRoot Flag whether the device group is the root group.
 */
final class DeviceGroupInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'children') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceGroupInputInputType($v)); })($value);
        }

        if ($name === 'devices') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'parentDeviceGroup') {
            return new DeviceGroupInputInputType($value);
        }

        if ($name === 'type') {
            return new DeviceGroupTypeEnum($value);
        }

        if ($name === 'definingDirectoryItems') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DirectoryInputInputType($v)); })($value);
        }

        if ($name === 'definingIP4Networks') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IP4NetworkInputInputType($v)); })($value);
        }

        if ($name === 'definingIP6Networks') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IP6NetworkInputInputType($v)); })($value);
        }

        if ($name === 'definingNetworkNeighborhoods') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new NetworkNeighborhoodInputInputType($v)); })($value);
        }

        return $value;
    }
}