<?php
namespace idoit\Module\JDisc\Graphql\Type;

class DeviceInputType extends AbstractType implements TypeInterface
{
    /**
     * @return string
     */
    public static function getType(): string
    {
        return 'DeviceInput';
    }

    /**
     * @return string
     */
    public function getFormattedValue(): string
    {
        $device = $this->getValue();

        $deviceArray = [];

        if (!empty($device['type'])) {
            $deviceArray[] = "type: {$device['type']}";
        }

        if (!empty($device['serialNumber'])) {
            $deviceArray[] = "serialNumber: \"{$device['serialNumber']}\"";
        }

        if (!empty($device['networkInterfaces']) && is_array($device['networkInterfaces'])) {
            $networkInterfaces = [];
            foreach ($device['networkInterfaces'] as $networkInterface) {
                $networkInterfaceKeyValue = [];
                foreach ($networkInterface as $key => $value) {
                    $networkInterfaceKeyValue[] = "{$key}:\"{$value}\"";
                }
                if ($networkInterfaceKeyValue) {
                    $networkInterfaces[] = '{' . implode(',', $networkInterfaceKeyValue) . '}';
                }
            }
            if ($networkInterfaces) {
                $deviceArray[] = 'networkInterfaces:[' . implode(',', $networkInterfaces) . ']';
            }
        }

        return '{' . implode(',', $deviceArray) . '}';
    }
}
