<?php

namespace idoit\Module\License\Entity;

use Carbon\Carbon;
use idoit\Module\License\LicenseService;

class License
{
    /**
     * @var int
     */
    private $id;

    /**
     * @var string
     */
    private $externalIdentifier;

    /**
     * sha1 hash of license data, used for identifying
     * @var string
     */
    private $licenseIdentifier;

    /**
     * @var \DateTimeInterface
     */
    private $validityFrom;

    /**
     * @var \DateTimeInterface
     */
    private $validityTo;

    /**
     * @var int
     */
    private $objects;

    /**
     * @var int
     */
    private $tenants;

    /**
     * @var string
     */
    private $productType;

    /**
     * @var string
     */
    private $productName;

    /**
     * @var string
     */
    private $productIdentifier;

    /**
     * @var bool
     */
    private $active;

    /**
     * @var bool
     */
    private $evaluation;

    /**
     * @var \DateTimeInterface
     */
    private $created;

    /**
     * @var string
     */
    private $environment;

    /**
     * @var string
     */
    private $decrypted;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @param string $externalIdentifier
     */
    public function setExternalIdentifier($externalIdentifier)
    {
        $this->externalIdentifier = $externalIdentifier;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getValidityFrom()
    {
        return $this->validityFrom;
    }

    /**
     * @param \DateTimeInterface $validityFrom
     */
    public function setValidityFrom($validityFrom)
    {
        if (!($validityFrom instanceof \DateTimeInterface)) {
            $validityFrom = new \DateTimeImmutable($validityFrom);
        }

        $this->validityFrom = $validityFrom;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getValidityTo()
    {
        return $this->validityTo;
    }

    /**
     * @param \DateTimeInterface $validityTo
     */
    public function setValidityTo($validityTo)
    {
        if (!($validityTo instanceof \DateTimeInterface)) {
            $validityTo = new \DateTimeImmutable($validityTo);
        }

        $this->validityTo = $validityTo;
    }

    /**
     * @return int
     */
    public function getObjects()
    {
        return $this->objects;
    }

    /**
     * @param int $objects
     */
    public function setObjects($objects)
    {
        $this->objects = $objects;
    }

    /**
     * @return int
     */
    public function getTenants()
    {
        return $this->tenants;
    }

    /**
     * @param int $tenants
     */
    public function setTenants($tenants)
    {
        $this->tenants = $tenants;
    }

    /**
     * @return string
     */
    public function getProductType()
    {
        return $this->productType;
    }

    /**
     * @param string $productType
     */
    public function setProductType($productType)
    {
        $this->productType = $productType;
    }

    /**
     * @return bool
     */
    public function isUnlimited(): bool
    {
        return Carbon::instance($this->validityTo)->diffInYears(Carbon::now()) > 75;
    }

    /**
     * @return bool
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @param bool $active
     */
    public function setActive($active)
    {
        $this->active = $active;
    }

    /**
     * @return bool
     */
    public function isEvaluation()
    {
        return $this->evaluation;
    }

    /**
     * @param bool $evaluation
     */
    public function setEvaluation($evaluation)
    {
        $this->evaluation = $evaluation;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param \DateTimeInterface $created
     */
    public function setCreated($created)
    {
        if (!($created instanceof \DateTimeInterface)) {
            $created = new \DateTimeImmutable($created);
        }

        $this->created = $created;
    }

    /**
     * @return string
     */
    public function getEnvironment()
    {
        return $this->environment;
    }

    /**
     * @param string $environment
     */
    public function setEnvironment($environment)
    {
        $this->environment = $environment;
    }

    /**
     * @return string
     */
    public function getDecrypted()
    {
        return $this->decrypted;
    }

    /**
     * @param string $decrypted
     *
     * @return License
     */
    public function setDecrypted($decrypted)
    {
        $this->decrypted = $decrypted;

        return $this;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
        return $this->productIdentifier;
    }

    /**
     * @param string $productIdentifier
     *
     * @return License
     */
    public function setProductIdentifier($productIdentifier)
    {
        $this->productIdentifier = $productIdentifier;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getProductName()
    {
        return $this->productName;
    }

    /**
     * @param mixed $productName
     * @return License
     */
    public function setProductName($productName)
    {
        $this->productName = $productName;
        return $this;
    }

    public function setLicenseIdentifier($licenseIdentifier)
    {
        $this->licenseIdentifier = $licenseIdentifier;
        return $this;
    }

    public function getLicenseIdentifier()
    {
        return $this->licenseIdentifier;
    }

    /**
     * @return bool
     */
    public function isIdoitLicense(): bool
    {
        return stripos($this->getProductType(), 'idoit') !== false || stripos($this->getProductType(), 'i-doit') !== false;
    }

    /**
     * @return int
     */
    public function daysLeft(): int
    {
        if ($this->isUnlimited()) {
            return -1;
        }

        return Carbon::instance($this->validityTo)->diffInDays(Carbon::instance($this->validityFrom));
    }

    /**
     * @return array
     */
    public function toLegacy(): array
    {
        return [
            LicenseService::LEGACY_LICENSE_EXPIRES => $this->getValidityTo()->format('Y-m-d H:i:s')
        ];
    }
}
